/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CallBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public class NewConnectionBuilder
extends CallBuilder {
    private static final String NEW_CONNECTION_LABEL = "New Connection";
    public static final String INIT_SYMBOL = "init";
    public static final String CHECK_ERROR_DOC = "Terminate on error";
    public static final String CONNECTION_NAME_LABEL = "Connection Name";
    public static final String CONNECTION_TYPE_LABEL = "Connection Type";
    private static final String CONNECTIONS_BAL = "connections.bal";
    private static final String DRIVER_SUB_PACKAGE = ".driver";
    public static final List<String> CONNECTION_DRIVERS = List.of("ballerinax/mysql", "ballerinax/postgresql", "ballerinax/oracledb", "ballerinax/mssql");

    @Override
    public void setConcreteConstData() {
        this.metadata().label(NEW_CONNECTION_LABEL);
        this.codedata().node(NodeKind.NEW_CONNECTION).symbol(INIT_SYMBOL);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.FINAL_KEYWORD).stepOut()).newVariable();
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.CHECK_KEYWORD).keyword(SyntaxKind.NEW_KEYWORD).stepOut()).functionParameters(sourceBuilder.flowNode, Set.of("variable", "type", "scope", "checkError"));
        Optional<Property> scope = sourceBuilder.getProperty("scope");
        if (scope.isEmpty()) {
            throw new IllegalStateException("Scope is not defined for the new connection node");
        }
        Codedata codedata = sourceBuilder.flowNode.codedata();
        Path filePath = sourceBuilder.filePath;
        switch (scope.get().value().toString()) {
            case "Local": {
                sourceBuilder.textEdit();
                NewConnectionBuilder.checkDriverImport(sourceBuilder, codedata, filePath);
                break;
            }
            case "Global": {
                sourceBuilder.textEdit();
                Path projectRoot = sourceBuilder.workspaceManager.projectRoot(filePath);
                NewConnectionBuilder.checkDriverImport(sourceBuilder, codedata, projectRoot.resolve(CONNECTIONS_BAL));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid scope for the new connection node");
            }
        }
        if (Boolean.TRUE.equals(codedata.isGenerated())) {
            sourceBuilder.addImport(codedata.module());
        } else {
            sourceBuilder.acceptImport();
        }
        return sourceBuilder.build();
    }

    private static void checkDriverImport(SourceBuilder sourceBuilder, Codedata codedata, Path filePath) {
        if (CONNECTION_DRIVERS.contains(codedata.getImportSignature())) {
            sourceBuilder.acceptImport(codedata.org(), codedata.module() + DRIVER_SUB_PACKAGE, true);
        }
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Codedata codedata = context.codedata();
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().parentSymbolType(codedata.object()).name(codedata.symbol()).moduleInfo(new ModuleInfo(codedata.org(), codedata.packageName(), codedata.module(), codedata.version())).lsClientLogger(context.lsClientLogger()).functionResultKind(FunctionData.Kind.CONNECTOR).userModuleInfo(this.moduleInfo);
        if (Boolean.TRUE.equals(codedata.isGenerated())) {
            Path projectPath = context.filePath().getParent();
            if (projectPath == null) {
                throw new IllegalStateException("Project path not found");
            }
            WorkspaceManager workspaceManager = context.workspaceManager();
            Project project = PackageUtil.loadProject((WorkspaceManager)workspaceManager, (Path)context.filePath());
            SemanticModel semanticModel = null;
            for (Module module : project.currentPackage().modules()) {
                String moduleNamePath = module.moduleName().moduleNamePart();
                if (moduleNamePath == null || !moduleNamePath.equals(codedata.module())) continue;
                semanticModel = PackageUtil.getCompilation((Project)project).getSemanticModel(module.moduleId());
                break;
            }
            if (semanticModel == null) {
                throw new IllegalStateException("Semantic model not found");
            }
            functionDataBuilder.semanticModel(semanticModel);
        }
        FunctionData functionData = functionDataBuilder.build();
        this.metadata().label(functionData.packageName()).description(functionData.description()).icon(CommonUtils.generateIcon((String)functionData.org(), (String)functionData.packageName(), (String)functionData.version()));
        this.codedata().node(NodeKind.NEW_CONNECTION).org(functionData.org()).module(functionData.moduleName()).packageName(functionData.packageName()).object(functionData.name()).version(functionData.version()).symbol(INIT_SYMBOL).isGenerated(codedata.isGenerated());
        this.setParameterProperties(functionData);
        if (CommonUtils.hasReturn((String)functionData.returnType())) {
            this.setReturnTypeProperties(functionData, context, CONNECTION_NAME_LABEL);
        }
        this.properties().scope("Global").checkError(true, CHECK_ERROR_DOC, false);
    }

    @Override
    protected NodeKind getFunctionNodeKind() {
        return NodeKind.NEW_CONNECTION;
    }

    @Override
    protected FunctionData.Kind getFunctionResultKind() {
        return FunctionData.Kind.CONNECTOR;
    }
}

