/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.PropertyCodedata;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CallBuilder;
import io.ballerina.flowmodelgenerator.core.utils.FlowNodeUtil;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public class ResourceActionCallBuilder
extends CallBuilder {
    public static final String TARGET_TYPE_KEY = "targetType";

    @Override
    public void setConcreteConstData() {
        this.codedata().node(NodeKind.RESOURCE_ACTION_CALL);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Codedata codedata = context.codedata();
        if (codedata.org().equals("$anon")) {
            return;
        }
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().name(codedata.symbol()).moduleInfo(new ModuleInfo(codedata.org(), codedata.packageName(), codedata.module(), codedata.version())).lsClientLogger(context.lsClientLogger()).parentSymbolType(codedata.object()).resourcePath(codedata.resourcePath()).project(PackageUtil.loadProject((WorkspaceManager)context.workspaceManager(), (Path)context.filePath())).functionResultKind(FunctionData.Kind.RESOURCE);
        FunctionData functionData = functionDataBuilder.build();
        this.metadata().label(functionData.name()).description(functionData.description()).icon(CommonUtils.generateIcon((String)functionData.org(), (String)functionData.packageName(), (String)functionData.version()));
        this.codedata().org(functionData.org()).module(functionData.packageName()).object(codedata.object()).symbol(functionData.name());
        this.setExpressionProperty(codedata);
        String resourcePath = functionData.resourcePath();
        this.properties().resourcePath(resourcePath, resourcePath.equals("/path/to/subdirectory"));
        this.setParameterProperties(functionData);
        String returnTypeName = functionData.returnType();
        if (CommonUtils.hasReturn((String)returnTypeName)) {
            this.setReturnTypeProperties(functionData, context, "Variable Name");
        }
        if (functionData.returnError()) {
            this.properties().checkError(true);
        }
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> connection;
        sourceBuilder.newVariableWithInferredType();
        FlowNode flowNode = sourceBuilder.flowNode;
        if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
            sourceBuilder.token().keyword(SyntaxKind.CHECK_KEYWORD);
        }
        if ((connection = sourceBuilder.getProperty("connection")).isEmpty()) {
            throw new IllegalStateException("Client must be defined for an action call node");
        }
        HashSet<String> ignoredKeys = new HashSet<String>(List.of("connection", "variable", "type", TARGET_TYPE_KEY, "resourcePath", "checkError"));
        String resourcePath = flowNode.properties().get("resourcePath").codedata().originalName();
        if (resourcePath.equals("/path/to/subdirectory")) {
            resourcePath = flowNode.properties().get("resourcePath").value().toString();
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(flowNode.properties().keySet());
        keys.removeAll(ignoredKeys);
        for (String key : keys) {
            PropertyCodedata propCodedata;
            Optional<Property> property = sourceBuilder.getProperty(key);
            if (property.isEmpty() || (propCodedata = property.get().codedata()) == null) continue;
            if (propCodedata.kind().equals(ParameterData.Kind.PATH_PARAM.name())) {
                String pathParamSubString = "[" + key + "]";
                String replacement = "[" + property.get().value().toString() + "]";
                resourcePath = resourcePath.replace(pathParamSubString, replacement);
                ignoredKeys.add(key);
                continue;
            }
            if (!propCodedata.kind().equals(ParameterData.Kind.PATH_REST_PARAM.name())) continue;
            String replacement = property.get().value().toString();
            resourcePath = resourcePath.replace("/path/to/resource", replacement);
            ignoredKeys.add(key);
        }
        return ((SourceBuilder)sourceBuilder.token().name(connection.get().toSourceCode()).keyword(SyntaxKind.RIGHT_ARROW_TOKEN).resourcePath(resourcePath).keyword(SyntaxKind.DOT_TOKEN).name(sourceBuilder.flowNode.codedata().symbol()).stepOut()).functionParameters(flowNode, ignoredKeys).textEdit().acceptImportWithVariableType().build();
    }

    @Override
    protected NodeKind getFunctionNodeKind() {
        return NodeKind.RESOURCE_ACTION_CALL;
    }

    @Override
    protected FunctionData.Kind getFunctionResultKind() {
        return FunctionData.Kind.RESOURCE;
    }
}

