/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class RetryBuilder
extends NodeBuilder {
    public static final String LABEL = "Retry Block";
    public static final String DESCRIPTION = "Retry block.";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.RETRY);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.branches = List.of(Branch.DEFAULT_BODY_BRANCH, Branch.getDefaultOnFailBranch(true));
        this.properties().retryCount(3);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Branch> body = sourceBuilder.flowNode.getBranch("Body");
        Property retryCount = sourceBuilder.flowNode.properties().get("retryCount");
        return ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.RETRY_KEYWORD).openParen().expression(retryCount).closeParen().whiteSpace().stepOut()).body(body.isPresent() ? body.get().children() : Collections.emptyList()).onFailure().textEdit().build();
    }
}

