/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class RollbackBuilder
extends NodeBuilder {
    public static final String LABEL = "Rollback";
    public static final String DESCRIPTION = "Rollback the transaction";
    public static final String ROLLBACK_EXPRESSION_DOC = "Rollback transaction";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.ROLLBACK);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().expression("", ROLLBACK_EXPRESSION_DOC);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        sourceBuilder.token().keyword(SyntaxKind.ROLLBACK_KEYWORD);
        Optional<Property> property = sourceBuilder.getProperty("expression");
        property.ifPresent(value -> sourceBuilder.token().whiteSpace().expression((Property)value));
        sourceBuilder.token().endOfStatement();
        return sourceBuilder.textEdit().build();
    }
}

