/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class StartBuilder
extends NodeBuilder {
    public static final String LABEL = "Start";
    public static final String DESCRIPTION = "Execute a function or a method invocation in a new strand";
    public static final String START_EXPRESSION_DOC = "Call action or expression";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.START);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> type = sourceBuilder.getProperty("type");
        Optional<Property> variable = sourceBuilder.getProperty("variable");
        if (type.isPresent() && variable.isPresent()) {
            sourceBuilder.token().expressionWithType(type.get(), variable.get()).keyword(SyntaxKind.EQUAL_TOKEN);
        }
        sourceBuilder.token().keyword(SyntaxKind.START_KEYWORD);
        Optional<Property> property = sourceBuilder.getProperty("expression");
        property.ifPresent(value -> sourceBuilder.token().whiteSpace().expression((Property)value));
        sourceBuilder.token().endOfStatement();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().dataVariable(null, true, context.getAllVisibleSymbolNames()).expressionOrAction(null, START_EXPRESSION_DOC, false);
    }
}

