/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class VariableBuilder
extends NodeBuilder {
    public static final String LABEL = "Declare Variable";
    public static final String DESCRIPTION = "New variable with type";
    public static final String EXPRESSION_DOC = "Initialize with value";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL);
        this.codedata().node(NodeKind.VARIABLE);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> exprProperty;
        Optional<Property> type = sourceBuilder.getProperty("type");
        Optional<Property> variable = sourceBuilder.getProperty("variable");
        if (type.isPresent() && variable.isPresent()) {
            sourceBuilder.token().expressionWithType(type.get(), variable.get());
        }
        if ((exprProperty = sourceBuilder.getProperty("expression")).isPresent() && !exprProperty.get().toSourceCode().isEmpty()) {
            sourceBuilder.token().keyword(SyntaxKind.EQUAL_TOKEN).expression(exprProperty.get());
        }
        sourceBuilder.token().endOfStatement();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.metadata().description(DESCRIPTION);
        this.properties().dataVariable(null, true, context.getAllVisibleSymbolNames()).expressionOrAction(null, EXPRESSION_DOC, true);
    }
}

