/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TypeUtils {
    private static final Set<TypeDescKind> BUILT_IN_TYPE_KINDS = Set.of(TypeDescKind.INT, TypeDescKind.BYTE, TypeDescKind.FLOAT, TypeDescKind.DECIMAL, TypeDescKind.BOOLEAN, TypeDescKind.STRING, TypeDescKind.READONLY, TypeDescKind.INT_SIGNED8, TypeDescKind.INT_SIGNED16, TypeDescKind.INT_SIGNED32, TypeDescKind.INT_UNSIGNED8, TypeDescKind.INT_UNSIGNED16, TypeDescKind.INT_UNSIGNED32, TypeDescKind.STRING_CHAR, TypeDescKind.ANYDATA, TypeDescKind.ANY, TypeDescKind.NIL, TypeDescKind.NEVER, TypeDescKind.XML, TypeDescKind.XML_COMMENT, TypeDescKind.XML_ELEMENT, TypeDescKind.XML_TEXT, TypeDescKind.XML_PROCESSING_INSTRUCTION);

    public static boolean isBuiltInType(TypeSymbol typeSymbol) {
        return BUILT_IN_TYPE_KINDS.contains(typeSymbol.typeKind());
    }

    public static List<String> getTypeRefIds(TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        ArrayList<String> typeRefs = new ArrayList<String>();
        TypeUtils.addTypeRefIds(typeSymbol, moduleInfo, typeRefs);
        return typeRefs;
    }

    public static String generateReferencedTypeId(TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        if (typeSymbol.getName().isEmpty()) {
            return typeSymbol.signature();
        }
        if (CommonUtils.isWithinPackage((Symbol)typeSymbol, (ModuleInfo)moduleInfo)) {
            return (String)typeSymbol.getName().get();
        }
        ModuleID moduleId = ((ModuleSymbol)typeSymbol.getModule().get()).id();
        return String.format("%s/%s:%s", moduleId.orgName(), moduleId.packageName(), typeSymbol.getName().get());
    }

    private static void addTypeRefIds(TypeSymbol ts, ModuleInfo moduleInfo, List<String> typeRefs) {
        if (TypeUtils.isBuiltInType(ts)) {
            return;
        }
        switch (ts.typeKind()) {
            case TYPE_REFERENCE: {
                typeRefs.add(TypeUtils.generateReferencedTypeId(ts, moduleInfo));
                break;
            }
            case ARRAY: {
                TypeUtils.addTypeRefIds(((ArrayTypeSymbol)ts).memberTypeDescriptor(), moduleInfo, typeRefs);
                break;
            }
            case UNION: {
                ((UnionTypeSymbol)ts).userSpecifiedMemberTypes().forEach(t -> TypeUtils.addTypeRefIds(t, moduleInfo, typeRefs));
                break;
            }
            case MAP: {
                TypeUtils.addTypeRefIds(((MapTypeSymbol)ts).typeParam(), moduleInfo, typeRefs);
                break;
            }
            case STREAM: {
                TypeUtils.addTypeRefIds(((StreamTypeSymbol)ts).typeParameter(), moduleInfo, typeRefs);
                break;
            }
            case INTERSECTION: {
                ((IntersectionTypeSymbol)ts).memberTypeDescriptors().forEach(t -> TypeUtils.addTypeRefIds(t, moduleInfo, typeRefs));
                break;
            }
            default: {
                typeRefs.add(ts.signature());
            }
        }
    }
}

