/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.nativeimpl;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.time.nativeimpl.Utc;
import io.ballerina.stdlib.time.util.Constants;
import io.ballerina.stdlib.time.util.Errors;
import io.ballerina.stdlib.time.util.TimeValueHandler;
import io.ballerina.stdlib.time.util.Utils;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ExternMethods {
    private ExternMethods() {
    }

    public static BArray externUtcNow(int precision) {
        Instant currentUtcTimeInstant = Instant.now();
        int precisionValue = 9;
        if (precision > 0 && precision <= 9) {
            precisionValue = precision;
        }
        return new Utc(currentUtcTimeInstant, precisionValue).build();
    }

    public static BDecimal externMonotonicNow() {
        long time = System.nanoTime();
        return ValueCreator.createDecimalValue((BigDecimal)new BigDecimal(time).divide(Constants.ANALOG_GIGA));
    }

    public static Object externUtcFromString(BString str) {
        try {
            Instant utcTimeInstant = ZonedDateTime.parse(str.getValue()).toInstant();
            return new Utc(utcTimeInstant).build();
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, "The provided string '" + str.getValue() + "' does not adhere to the expected RFC 3339 format 'YYYY-MM-DDTHH:MM:SS.SSZ'. ");
        }
    }

    public static BString externUtcToString(BArray utc) {
        Instant time = new Utc(utc).generateInstant();
        return StringUtils.fromString((String)time.toString());
    }

    public static BDecimal externUtcDiffSeconds(BArray utc1, BArray utc2) {
        Instant time1 = new Utc(utc1).generateInstant();
        Instant time2 = new Utc(utc2).generateInstant();
        time1 = time1.minusNanos(time2.getNano());
        time1 = time1.minusSeconds(time2.getEpochSecond());
        BigDecimal nanoSeconds = new BigDecimal(time1.getNano()).divide(Constants.ANALOG_GIGA);
        BigDecimal seconds = new BigDecimal(time1.getEpochSecond()).add(nanoSeconds);
        return ValueCreator.createDecimalValue((BigDecimal)seconds);
    }

    public static Object externDateValidate(BMap date) {
        int year = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_YEAR_BSTRING));
        int month = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_MONTH_BSTRING));
        int day = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_DAY_BSTRING));
        try {
            LocalDate.of(year, month, day);
            return null;
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static Object externDayOfWeek(BMap date) {
        int year = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_YEAR_BSTRING));
        int month = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_MONTH_BSTRING));
        int day = Math.toIntExact(date.getIntValue(Constants.DATE_RECORD_DAY_BSTRING));
        try {
            return LocalDate.of(year, month, day).getDayOfWeek().getValue() % 7;
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static BMap externUtcToCivil(BArray utc) {
        Instant time = new Utc(utc).generateInstant();
        ZonedDateTime zonedDateTime = time.atZone(ZoneId.of("Z"));
        return TimeValueHandler.createCivilFromZoneDateTime(zonedDateTime);
    }

    public static Object externUtcFromCivil(long year, long month, long day, long hour, long minute, BDecimal second, long zoneHour, long zoneMinute, BDecimal zoneSecond) {
        try {
            ZonedDateTime dateTime = TimeValueHandler.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, zoneHour, zoneMinute, zoneSecond, null, Constants.HeaderZoneHandling.PREFER_ZONE_OFFSET.toString());
            return new Utc(dateTime.toInstant()).build();
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static Object externCivilFromString(BString dateTimeString) {
        try {
            return TimeValueHandler.createCivilFromZoneDateTimeString(dateTimeString.getValue());
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static Object externCivilFromEmailString(BString dateTimeString) {
        try {
            return TimeValueHandler.createCivilFromEmailString(dateTimeString.getValue());
        }
        catch (IllegalArgumentException | DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static Object externCivilToString(long year, long month, long day, long hour, long minute, BDecimal second, long zoneHour, long zoneMinute, BDecimal zoneSecond, BString zoneAbbr, BString zoneHandling) {
        try {
            ZonedDateTime dateTime = TimeValueHandler.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, zoneHour, zoneMinute, zoneSecond, zoneAbbr, zoneHandling.getValue());
            return StringUtils.fromString((String)dateTime.toString());
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }

    public static BString externUtcToEmailString(BArray utc, BString zh) {
        Instant time = new Utc(utc).generateInstant();
        String zhString = zh.getValue();
        if (zhString.equals("0")) {
            zhString = "+0000";
        }
        return StringUtils.fromString((String)ZonedDateTime.ofInstant(time, ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME).replace("GMT", zhString).replace("+0000", zhString));
    }

    public static Object externCivilToEmailString(long year, long month, long day, long hour, long minute, BDecimal second, long zoneHour, long zoneMinute, BDecimal zoneSecond, BString zoneAbbr, BString zoneHandling) {
        try {
            ZonedDateTime dateTime = TimeValueHandler.createZoneDateTimeFromCivilValues(year, month, day, hour, minute, second, zoneHour, zoneMinute, zoneSecond, zoneAbbr, zoneHandling.getValue());
            if (Constants.HeaderZoneHandling.PREFER_ZONE_OFFSET.toString().equals(zoneHandling.getValue())) {
                return StringUtils.fromString((String)dateTime.format(DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss Z")));
            }
            return StringUtils.fromString((String)dateTime.format(DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss Z[ ][(z)]")));
        }
        catch (DateTimeException e) {
            return Utils.createError(Errors.FormatError, e.getMessage());
        }
    }
}

