/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.time.nativeimpl;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.stdlib.time.util.Constants;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;

public class Utc {
    private long secondsFromEpoc = 0L;
    private BigDecimal lastSecondFraction = new BigDecimal(0);

    public Utc(Instant instant) {
        this.secondsFromEpoc = instant.getEpochSecond();
        this.lastSecondFraction = new BigDecimal(instant.getNano()).divide(Constants.ANALOG_GIGA, MathContext.DECIMAL128);
    }

    public Utc(Instant instant, int precision) {
        this.secondsFromEpoc = instant.getEpochSecond();
        this.lastSecondFraction = new BigDecimal(instant.getNano()).divide(Constants.ANALOG_GIGA, MathContext.DECIMAL128).setScale(precision, RoundingMode.HALF_UP);
    }

    public Utc(BArray utc) {
        if (utc.getLength() == 2L) {
            this.secondsFromEpoc = utc.getInt(0L);
            this.lastSecondFraction = new BigDecimal(utc.getValues()[1].toString()).multiply(Constants.ANALOG_GIGA);
        } else if (utc.getLength() == 1L) {
            this.secondsFromEpoc = utc.getInt(0L);
        }
    }

    public Utc(Date date) {
        this.secondsFromEpoc = date.getTime() / 1000L;
        this.lastSecondFraction = new BigDecimal(date.getTime() % 1000L).divide(new BigDecimal(1000), MathContext.DECIMAL128).setScale(9, RoundingMode.HALF_UP);
    }

    public Utc(long millis) {
        this.secondsFromEpoc = millis / 1000L;
        this.lastSecondFraction = new BigDecimal(millis % 1000L).divide(new BigDecimal(1000), MathContext.DECIMAL128).setScale(9, RoundingMode.HALF_UP);
    }

    public BArray build() {
        TupleType utcTupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL));
        BArray utcTuple = ValueCreator.createTupleValue((TupleType)utcTupleType);
        utcTuple.add(0L, this.secondsFromEpoc);
        utcTuple.add(1L, (Object)ValueCreator.createDecimalValue((BigDecimal)this.lastSecondFraction));
        utcTuple.freezeDirect();
        return utcTuple;
    }

    public Instant generateInstant() {
        return Instant.ofEpochSecond(this.secondsFromEpoc, this.lastSecondFraction.intValue());
    }

    public ZonedDateTime generateZonedDateAtZ() {
        return Instant.ofEpochSecond(this.secondsFromEpoc, this.lastSecondFraction.intValue()).atZone(ZoneId.of("Z"));
    }
}

