/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.ValueCreator;

public final class ErrorCreator {
    private static final BString ERROR_MESSAGE_FIELD = StringUtils.fromString("message");

    private ErrorCreator() {
    }

    public static BError createError(BString message) {
        return new ErrorValue(message);
    }

    public static BError createError(BString message, BMap<BString, Object> details) {
        details = RuntimeUtils.validateErrorDetails(details);
        return new ErrorValue(message, details);
    }

    public static BError createError(BString message, BString details) {
        BMapInitialValueEntry[] initialValues = details != null ? new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, details)} : new MappingInitialValueEntry[]{};
        MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return ErrorCreator.createError(message, detailMap);
    }

    public static BError createError(BString message, Throwable throwable) {
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage()), message, ErrorCreator.createError(StringUtils.fromString(throwable.getMessage())), new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    public static BError createError(Type type, BString message, BError cause, BMap<BString, Object> details) {
        details = RuntimeUtils.validateErrorDetails(details);
        ((BErrorType)type).setDetailType(TypeChecker.getType(details));
        return new ErrorValue(type, message, cause, details);
    }

    public static BError createError(Type type, BString message, BString details) {
        BMapInitialValueEntry[] initialValues = details != null ? new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, details)} : new MappingInitialValueEntry[]{};
        MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return ErrorCreator.createError(type, message, null, detailMap);
    }

    public static BError createError(Throwable error) {
        if (error instanceof BError) {
            BError bError = (BError)error;
            return bError;
        }
        BError bError = ErrorCreator.createError(StringUtils.fromString(error.toString()));
        bError.setStackTrace(error.getStackTrace());
        return bError;
    }

    public static BError createError(Module module, String errorTypeName, BString message, BError cause, BMap<BString, Object> details) throws BError {
        details = RuntimeUtils.validateErrorDetails(details);
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(module, false));
        try {
            return valueCreator.createErrorValue(errorTypeName, message, cause, details);
        }
        catch (BError e) {
            String testLookupKey = ValueCreator.getLookupKey(module, true);
            if (ValueCreator.containsValueCreator(testLookupKey)) {
                return ValueCreator.getValueCreator(testLookupKey).createErrorValue(errorTypeName, message, cause, details);
            }
            throw e;
        }
    }

    @Deprecated
    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message) {
        return ErrorCreator.createDistinctError(typeIdName, typeIdPkg, message, new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    @Deprecated
    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message, BMap<BString, Object> details) {
        details = RuntimeUtils.validateErrorDetails(details);
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, null, details, typeIdName, typeIdPkg);
    }

    @Deprecated
    public static BError createDistinctError(String typeIdName, Module typeIdPkg, BString message, BError cause) {
        MapValueImpl<BString, Object> details = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL);
        return new ErrorValue(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, cause, details, typeIdName, typeIdPkg);
    }
}

