/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.AnyType;
import io.ballerina.runtime.api.types.AnydataType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.BooleanType;
import io.ballerina.runtime.api.types.ByteType;
import io.ballerina.runtime.api.types.DecimalType;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.FloatType;
import io.ballerina.runtime.api.types.FutureType;
import io.ballerina.runtime.api.types.HandleType;
import io.ballerina.runtime.api.types.IntegerType;
import io.ballerina.runtime.api.types.IteratorType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.NeverType;
import io.ballerina.runtime.api.types.NullType;
import io.ballerina.runtime.api.types.ReadonlyType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StringType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypedescType;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlAttributesType;
import io.ballerina.runtime.api.types.XmlType;
import io.ballerina.runtime.internal.types.BAnyType;
import io.ballerina.runtime.internal.types.BAnydataType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BBooleanType;
import io.ballerina.runtime.internal.types.BByteType;
import io.ballerina.runtime.internal.types.BDecimalType;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BFloatType;
import io.ballerina.runtime.internal.types.BFutureType;
import io.ballerina.runtime.internal.types.BHandleType;
import io.ballerina.runtime.internal.types.BIntegerType;
import io.ballerina.runtime.internal.types.BIteratorType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BNeverType;
import io.ballerina.runtime.internal.types.BNullType;
import io.ballerina.runtime.internal.types.BReadonlyType;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.types.BStreamType;
import io.ballerina.runtime.internal.types.BStringType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTypedescType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlAttributesType;
import io.ballerina.runtime.internal.types.BXmlType;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PredefinedTypes {
    public static final Module EMPTY_MODULE = new Module(null, null, null);
    public static final IntegerType TYPE_INT = new BIntegerType("int", EMPTY_MODULE);
    public static final IntegerType TYPE_INT_SIGNED_8 = new BIntegerType("Signed8", new Module("ballerina", "lang.int", null), 7);
    public static final IntegerType TYPE_INT_SIGNED_16 = new BIntegerType("Signed16", new Module("ballerina", "lang.int", null), 9);
    public static final IntegerType TYPE_INT_SIGNED_32 = new BIntegerType("Signed32", new Module("ballerina", "lang.int", null), 11);
    public static final IntegerType TYPE_INT_UNSIGNED_8 = new BIntegerType("Unsigned8", new Module("ballerina", "lang.int", null), 8);
    public static final IntegerType TYPE_INT_UNSIGNED_16 = new BIntegerType("Unsigned16", new Module("ballerina", "lang.int", null), 10);
    public static final IntegerType TYPE_INT_UNSIGNED_32 = new BIntegerType("Unsigned32", new Module("ballerina", "lang.int", null), 12);
    public static final BooleanType TYPE_BOOLEAN = new BBooleanType("boolean", EMPTY_MODULE);
    public static final ByteType TYPE_BYTE = new BByteType("byte", EMPTY_MODULE);
    public static final FloatType TYPE_FLOAT = new BFloatType("float", EMPTY_MODULE);
    public static final DecimalType TYPE_DECIMAL = new BDecimalType("decimal", EMPTY_MODULE);
    public static final StringType TYPE_STRING = new BStringType("string", EMPTY_MODULE);
    public static final StringType TYPE_STRING_CHAR = new BStringType("Char", new Module("ballerina", "lang.string", null), 13);
    public static final ReadonlyType TYPE_READONLY = new BReadonlyType("readonly", EMPTY_MODULE);
    public static final XmlType TYPE_ELEMENT = new BXmlType("Element", new Module("ballerina", "lang.xml", null), 18, false);
    public static final Type TYPE_READONLY_ELEMENT = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_ELEMENT);
    public static final XmlType TYPE_PROCESSING_INSTRUCTION = new BXmlType("ProcessingInstruction", new Module("ballerina", "lang.xml", null), 19, false);
    public static final Type TYPE_READONLY_PROCESSING_INSTRUCTION = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_PROCESSING_INSTRUCTION);
    public static final XmlType TYPE_COMMENT = new BXmlType("Comment", new Module("ballerina", "lang.xml", null), 20, false);
    public static final Type TYPE_READONLY_COMMENT = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_COMMENT);
    public static final XmlType TYPE_TEXT = new BXmlType("Text", new Module("ballerina", "lang.xml", null), 21, true);
    public static final Type TYPE_XML_NEVER = new BXmlType("xml", new BNeverType(EMPTY_MODULE), EMPTY_MODULE, true);
    public static final Type TYPE_XML = new BXmlType("xml", new BUnionType(Arrays.asList(TYPE_ELEMENT, TYPE_COMMENT, TYPE_PROCESSING_INSTRUCTION, TYPE_TEXT)), EMPTY_MODULE);
    public static final Type TYPE_READONLY_XML = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_XML);
    public static final Type TYPE_XML_ELEMENT_SEQUENCE = new BXmlType(TYPE_ELEMENT, false);
    public static final Type TYPE_XML_COMMENT_SEQUENCE = new BXmlType(TYPE_COMMENT, false);
    public static final Type TYPE_XML_PI_SEQUENCE = new BXmlType(TYPE_PROCESSING_INSTRUCTION, false);
    public static final Type TYPE_XML_TEXT_SEQUENCE = new BXmlType(TYPE_TEXT, false);
    public static final AnyType TYPE_ANY = new BAnyType("any", EMPTY_MODULE, false);
    public static final AnyType TYPE_READONLY_ANY = new BAnyType("any & readonly", EMPTY_MODULE, true);
    public static final TypedescType TYPE_TYPEDESC = new BTypedescType("typedesc", EMPTY_MODULE);
    public static final MapType TYPE_MAP = new BMapType("map", TYPE_ANY, EMPTY_MODULE);
    public static final FutureType TYPE_FUTURE = new BFutureType("future", EMPTY_MODULE);
    public static final NullType TYPE_NULL = new BNullType("()", EMPTY_MODULE);
    public static final NeverType TYPE_NEVER = new BNeverType(EMPTY_MODULE);
    public static final XmlAttributesType TYPE_XML_ATTRIBUTES = new BXmlAttributesType("xml-attributes", EMPTY_MODULE);
    public static final IteratorType TYPE_ITERATOR = new BIteratorType("iterator", EMPTY_MODULE);
    public static final ServiceType TYPE_ANY_SERVICE = new BServiceType("service", EMPTY_MODULE, 0L);
    public static final HandleType TYPE_HANDLE = new BHandleType("handle", EMPTY_MODULE);
    public static final StreamType TYPE_STREAM = new BStreamType("stream", TYPE_ANY, TYPE_NULL, EMPTY_MODULE);
    public static final ArrayType TYPE_ANY_ARRAY = new BArrayType(TYPE_ANY);
    public static final JsonType TYPE_JSON;
    public static final JsonType TYPE_READONLY_JSON;
    public static final ArrayType TYPE_JSON_ARRAY;
    public static final AnydataType TYPE_ANYDATA;
    public static final AnydataType TYPE_READONLY_ANYDATA;
    public static final ArrayType TYPE_ANYDATA_ARRAY;
    public static final MapType TYPE_DETAIL;
    public static final Type TYPE_ERROR_DETAIL;
    public static final ErrorType TYPE_ERROR;
    public static final UnionType TYPE_CLONEABLE;
    public static final UnionType TYPE_JSON_DECIMAL;
    public static final UnionType TYPE_JSON_FLOAT;
    public static final RecordType STRING_ITR_NEXT_RETURN_TYPE;
    public static final Type ANY_AND_READONLY_TYPE;
    public static final Type ANY_AND_READONLY_OR_ERROR_TYPE;

    private PredefinedTypes() {
    }

    private static BAnydataType getAnydataType(List<Type> members, String typeName, boolean readonly) {
        BAnydataType anydataType = new BAnydataType(new BUnionType("anydata", EMPTY_MODULE, members, readonly), typeName, readonly);
        anydataType.isCyclic = true;
        BMapType internalAnydataMap = new BMapType("map", anydataType, EMPTY_MODULE, readonly);
        BArrayType internalAnydataArray = new BArrayType((Type)anydataType, readonly);
        BTableType internalAnydataMapTable = new BTableType(internalAnydataMap, readonly);
        anydataType.addMembers(internalAnydataArray, internalAnydataMap, internalAnydataMapTable);
        return anydataType;
    }

    static {
        STRING_ITR_NEXT_RETURN_TYPE = IteratorUtils.createIteratorNextReturnType(TYPE_STRING_CHAR);
        ANY_AND_READONLY_TYPE = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_ANY);
        ArrayList<Type> members = new ArrayList<Type>();
        members.add(TYPE_NULL);
        members.add(TYPE_BOOLEAN);
        members.add(TYPE_INT);
        members.add(TYPE_FLOAT);
        members.add(TYPE_DECIMAL);
        members.add(TYPE_STRING);
        members.add(TYPE_XML);
        TYPE_ANYDATA = PredefinedTypes.getAnydataType(members, "anydata", false);
        TYPE_READONLY_ANYDATA = PredefinedTypes.getAnydataType(members, "anydata & readonly", true);
        TYPE_ANYDATA_ARRAY = new BArrayType(TYPE_ANYDATA);
        members = new ArrayList();
        members.add(TYPE_NULL);
        members.add(TYPE_BOOLEAN);
        members.add(TYPE_INT);
        members.add(TYPE_FLOAT);
        members.add(TYPE_DECIMAL);
        members.add(TYPE_STRING);
        BJsonType jsonType = new BJsonType(new BUnionType("json", EMPTY_MODULE, members, false), "json", false);
        jsonType.isCyclic = true;
        BMapType internalJsonMap = new BMapType("map", jsonType, EMPTY_MODULE);
        BArrayType internalJsonArray = new BArrayType(jsonType);
        jsonType.addMembers(internalJsonArray, internalJsonMap);
        TYPE_JSON = jsonType;
        TYPE_JSON_ARRAY = new BArrayType(TYPE_JSON);
        TYPE_READONLY_JSON = new BJsonType(jsonType, "json & readonly", true);
        members = new ArrayList();
        members.add(TYPE_XML);
        members.add(TYPE_READONLY);
        Module valueModule = new Module("ballerina", "lang.value", null);
        BUnionType cloneable = new BUnionType("Cloneable", valueModule, members, false);
        cloneable.isCyclic = true;
        BMapType internalCloneableMap = new BMapType("map", cloneable, valueModule);
        BArrayType internalCloneableArray = new BArrayType(cloneable);
        BTableType internalCloneableMapTable = new BTableType(internalCloneableMap, false);
        cloneable.addMembers(internalCloneableMap, internalCloneableArray, internalCloneableMapTable);
        TYPE_CLONEABLE = cloneable;
        TYPE_DETAIL = new BMapType("map", TYPE_CLONEABLE, EMPTY_MODULE);
        TYPE_ERROR_DETAIL = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(TYPE_DETAIL);
        TYPE_ERROR = new BErrorType("error", EMPTY_MODULE, TYPE_DETAIL);
        ANY_AND_READONLY_OR_ERROR_TYPE = new BUnionType(Arrays.asList(ANY_AND_READONLY_TYPE, TYPE_ERROR));
        members = new ArrayList();
        members.add(TYPE_NULL);
        members.add(TYPE_BOOLEAN);
        members.add(TYPE_STRING);
        members.add(TYPE_DECIMAL);
        valueModule = new Module("ballerina", "lang.value", null);
        BUnionType jsonDecimal = new BUnionType("JsonDecimal", valueModule, members, false);
        jsonDecimal.isCyclic = true;
        BMapType internalJsonDecimalMap = new BMapType("map", jsonDecimal, valueModule);
        BArrayType internalJsonDecimalArray = new BArrayType(jsonDecimal);
        jsonDecimal.addMembers(internalJsonDecimalArray, internalJsonDecimalMap);
        TYPE_JSON_DECIMAL = jsonDecimal;
        members = new ArrayList();
        members.add(TYPE_NULL);
        members.add(TYPE_BOOLEAN);
        members.add(TYPE_STRING);
        members.add(TYPE_FLOAT);
        valueModule = new Module("ballerina", "lang.value", null);
        BUnionType jsonFloat = new BUnionType("JsonFloat", valueModule, members, false);
        jsonFloat.isCyclic = true;
        BMapType internalJsonFloatMap = new BMapType("map", jsonFloat, valueModule);
        BArrayType internalJsonFloatArray = new BArrayType(jsonFloat);
        jsonFloat.addMembers(internalJsonFloatArray, internalJsonFloatMap);
        TYPE_JSON_FLOAT = jsonFloat;
    }
}

