/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import com.github.benmanes.caffeine.cache.Interner;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.PredefinedTypeEnv;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.api.types.semtype.TypeAtom;
import io.ballerina.runtime.internal.types.semtype.BBooleanSubType;
import io.ballerina.runtime.internal.types.semtype.BCellSubType;
import io.ballerina.runtime.internal.types.semtype.BDecimalSubType;
import io.ballerina.runtime.internal.types.semtype.BFloatSubType;
import io.ballerina.runtime.internal.types.semtype.BIntSubType;
import io.ballerina.runtime.internal.types.semtype.BListSubType;
import io.ballerina.runtime.internal.types.semtype.BMappingSubType;
import io.ballerina.runtime.internal.types.semtype.BStringSubType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.FixedLengthArray;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;
import io.ballerina.runtime.internal.types.semtype.TableUtils;
import io.ballerina.runtime.internal.types.semtype.XmlUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.stream.Stream;

public final class Builder {
    private static final String[] EMPTY_STRING_ARR = new String[0];
    private static final SemType VAL = SemType.from(262143);
    private static final SemType OBJECT = Builder.from(BasicTypeCode.BT_OBJECT);
    private static final SemType INHERENTLY_IMMUTABLE = SemType.from(2047);
    private static final SemType INNER = Builder.getBasicTypeUnion(VAL.all() | Builder.from(BasicTypeCode.BT_UNDEF).all());
    private static final SemType ANY = Builder.getBasicTypeUnion(0x3FFFF & ~(1 << BasicTypeCode.BT_ERROR.code()));
    private static final SemType SIMPLE_OR_STRING = Builder.getBasicTypeUnion(1 << BasicTypeCode.BT_NIL.code() | 1 << BasicTypeCode.BT_BOOLEAN.code() | 1 << BasicTypeCode.BT_INT.code() | 1 << BasicTypeCode.BT_FLOAT.code() | 1 << BasicTypeCode.BT_DECIMAL.code() | 1 << BasicTypeCode.BT_REGEXP.code() | 1 << BasicTypeCode.BT_STRING.code());
    private static final SemType[] EMPTY_TYPES_ARR = new SemType[0];
    private static final ConcurrentLazySupplier<SemType> MAPPING_RO = new ConcurrentLazySupplier<SemType>(() -> Builder.basicSubType(BasicTypeCode.BT_MAPPING, BMappingSubType.createDelegate(Builder.getBddSubtypeRo())));
    private static final ConcurrentLazySupplier<SemType> ANYDATA = new ConcurrentLazySupplier<SemType>(() -> {
        Env env = Env.getInstance();
        ListDefinition listDef = new ListDefinition();
        MappingDefinition mapDef = new MappingDefinition();
        SemType tableTy = TableUtils.tableContaining(env, mapDef.getSemType(env));
        SemType accum = Stream.of(Builder.getSimpleOrStringType(), Builder.getXmlType(), listDef.getSemType(env), mapDef.getSemType(env), tableTy).reduce(Builder.getNeverType(), Core::union);
        listDef.defineListTypeWrapped(env, EMPTY_TYPES_ARR, 0, accum, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        mapDef.defineMappingTypeWrapped(env, new MappingDefinition.Field[0], accum, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        return accum;
    });
    private static final ConcurrentLazySupplier<SemType> INNER_RO = new ConcurrentLazySupplier<SemType>(() -> Core.union(Builder.getReadonlyType(), Builder.getInnerType()));
    private static final ConcurrentLazySupplier<ListAtomicType> LIST_ATOMIC_INNER = new ConcurrentLazySupplier<ListAtomicType>(() -> new ListAtomicType(FixedLengthArray.empty(), PredefinedTypeEnv.getInstance().cellSemTypeInner()));
    private static final ConcurrentLazySupplier<MappingAtomicType> MAPPING_ATOMIC_INNER = new ConcurrentLazySupplier<MappingAtomicType>(() -> new MappingAtomicType(EMPTY_STRING_ARR, EMPTY_TYPES_ARR, PredefinedTypeEnv.getInstance().cellSemTypeInner()));
    private static final ConcurrentLazySupplier<SemType> XML_ELEMENT = new ConcurrentLazySupplier<SemType>(() -> XmlUtils.xmlSingleton(36));
    private static final ConcurrentLazySupplier<SemType> XML_COMMENT = new ConcurrentLazySupplier<SemType>(() -> XmlUtils.xmlSingleton(144));
    private static final ConcurrentLazySupplier<SemType> XML_TEXT = new ConcurrentLazySupplier<SemType>(() -> XmlUtils.xmlSingleton(2));
    private static final ConcurrentLazySupplier<SemType> XML_PI = new ConcurrentLazySupplier<SemType>(() -> XmlUtils.xmlSingleton(72));
    private static final ConcurrentLazySupplier<SemType> XML_NEVER = new ConcurrentLazySupplier<SemType>(() -> XmlUtils.xmlSingleton(1));
    private static final PredefinedTypeEnv PREDEFINED_TYPE_ENV = PredefinedTypeEnv.getInstance();
    private static final BddNode LIST_SUBTYPE_THREE_ELEMENT = BddNode.bddAtom(PREDEFINED_TYPE_ENV.atomListThreeElement());
    private static final BddNode LIST_SUBTYPE_THREE_ELEMENT_RO = BddNode.bddAtom(PREDEFINED_TYPE_ENV.atomListThreeElementRO());
    private static final BddNode LIST_SUBTYPE_TWO_ELEMENT = BddNode.bddAtom(PREDEFINED_TYPE_ENV.atomListTwoElement());

    private Builder() {
    }

    public static SemType from(BasicTypeCode typeCode) {
        assert (0 <= typeCode.code() && typeCode.code() <= 19);
        return BasicTypeCache.cache[typeCode.code()];
    }

    public static SemType getNeverType() {
        return SemType.from(0);
    }

    public static SemType getNilType() {
        return Builder.from(BasicTypeCode.BT_NIL);
    }

    public static SemType getUndefType() {
        return Builder.from(BasicTypeCode.BT_UNDEF);
    }

    public static SemType getCellType() {
        return Builder.from(BasicTypeCode.BT_CELL);
    }

    public static SemType getInnerType() {
        return INNER;
    }

    public static SemType getIntType() {
        return Builder.from(BasicTypeCode.BT_INT);
    }

    public static SemType getDecimalType() {
        return Builder.from(BasicTypeCode.BT_DECIMAL);
    }

    public static SemType getFloatType() {
        return Builder.from(BasicTypeCode.BT_FLOAT);
    }

    public static SemType getBooleanType() {
        return Builder.from(BasicTypeCode.BT_BOOLEAN);
    }

    public static SemType getStringType() {
        return Builder.from(BasicTypeCode.BT_STRING);
    }

    public static SemType getCharType() {
        return StringTypeCache.charType;
    }

    public static SemType getListType() {
        return Builder.from(BasicTypeCode.BT_LIST);
    }

    public static SemType getReadonlyType() {
        return PREDEFINED_TYPE_ENV.readonlyType();
    }

    static SemType getBasicTypeUnion(int bitset) {
        return switch (bitset) {
            case 0 -> Builder.getNeverType();
            case 262143 -> VAL;
            default -> {
                if (Integer.bitCount(bitset) == 1) {
                    int code = Integer.numberOfTrailingZeros(bitset);
                    if (!($assertionsDisabled || code >= 0 && code <= 19)) {
                        throw new AssertionError();
                    }
                    yield BasicTypeCache.cache[code];
                }
                yield SemType.from(bitset);
            }
        };
    }

    public static SemType basicSubType(BasicTypeCode basicTypeCode, SubType subType) {
        assert (!(subType instanceof Bdd)) : "BDD should always be wrapped with a delegate";
        assert (Builder.checkDelegate(basicTypeCode, subType)) : "BDd is wrapped in wrong delegate";
        int some = 1 << basicTypeCode.code();
        SubType[] subTypes = Builder.initializeSubtypeArray(some);
        subTypes[0] = subType;
        return SemType.from(0, some, subTypes);
    }

    private static boolean checkDelegate(BasicTypeCode basicTypeCode, SubType subType) {
        return !(basicTypeCode == BasicTypeCode.BT_MAPPING && !(subType instanceof BMappingSubType) || basicTypeCode == BasicTypeCode.BT_LIST && !(subType instanceof BListSubType) || basicTypeCode == BasicTypeCode.BT_CELL && !(subType instanceof BCellSubType));
    }

    public static SemType getIntConst(long value) {
        if (value >= -128L && value <= 127L) {
            return IntTypeCache.cache[(int)value - -128];
        }
        return Builder.createIntSingletonType(value);
    }

    private static SemType createIntSingletonType(long value) {
        ArrayList<Long> values = new ArrayList<Long>(1);
        values.add(value);
        return Builder.basicSubType(BasicTypeCode.BT_INT, BIntSubType.createIntSubType(values));
    }

    public static SemType getBooleanConst(boolean value) {
        return value ? BooleanTypeCache.TRUE : BooleanTypeCache.FALSE;
    }

    public static SemType createIntRange(long min, long max) {
        return Builder.basicSubType(BasicTypeCode.BT_INT, BIntSubType.createIntSubType(min, max));
    }

    public static SemType getDecimalConst(BigDecimal value) {
        BigDecimal[] values = new BigDecimal[]{value};
        return Builder.basicSubType(BasicTypeCode.BT_DECIMAL, BDecimalSubType.createDecimalSubType(true, values));
    }

    public static SemType getFloatConst(double value) {
        Double[] values = new Double[]{value};
        return Builder.basicSubType(BasicTypeCode.BT_FLOAT, BFloatSubType.createFloatSubType(true, values));
    }

    public static SemType getStringConst(String value) {
        String[] values = new String[]{value};
        String[] empty = EMPTY_STRING_ARR;
        BStringSubType subType = value.length() == 1 || value.codePointCount(0, value.length()) == 1 ? BStringSubType.createStringSubType(true, values, true, empty) : BStringSubType.createStringSubType(true, empty, true, values);
        return Builder.basicSubType(BasicTypeCode.BT_STRING, subType);
    }

    public static Interner<String> getStringInterner() {
        return StringTypeCache.interner;
    }

    static SubType[] initializeSubtypeArray(int some) {
        return new SubType[Integer.bitCount(some)];
    }

    public static SemType getRoCellContaining(Env env, SemType ty) {
        return Builder.getCellContaining(env, ty, CellAtomicType.CellMutability.CELL_MUT_NONE);
    }

    public static SemType getRwCellContaining(Env env, SemType ty) {
        return Builder.getCellContaining(env, ty, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public static SemType getCellContaining(Env env, SemType ty, CellAtomicType.CellMutability mut) {
        return env.getCachedCellType(ty, mut, () -> Builder.createCellSemType(env, ty, mut));
    }

    private static SemType createCellSemType(Env env, SemType ty, CellAtomicType.CellMutability mut) {
        CellAtomicType atomicCell = CellAtomicType.from(ty, mut);
        TypeAtom atom = env.cellAtom(atomicCell);
        BddNode bdd = BddNode.bddAtom(atom);
        return Builder.basicSubType(BasicTypeCode.BT_CELL, BCellSubType.createDelegate(bdd));
    }

    public static SemType getValType() {
        return Builder.getBasicTypeUnion(262143);
    }

    public static SemType getAnyType() {
        return ANY;
    }

    public static SemType getMappingType() {
        return Builder.from(BasicTypeCode.BT_MAPPING);
    }

    public static SemType getFunctionType() {
        return Builder.from(BasicTypeCode.BT_FUNCTION);
    }

    public static SemType getErrorType() {
        return Builder.from(BasicTypeCode.BT_ERROR);
    }

    public static SemType getXmlType() {
        return Builder.from(BasicTypeCode.BT_XML);
    }

    public static SemType getXmlElementType() {
        return XML_ELEMENT.get();
    }

    public static SemType getXmlCommentType() {
        return XML_COMMENT.get();
    }

    public static SemType getXmlTextType() {
        return XML_TEXT.get();
    }

    public static SemType getXmlNeverType() {
        return XML_NEVER.get();
    }

    public static SemType getXmlPIType() {
        return XML_PI.get();
    }

    public static SemType getHandleType() {
        return Builder.from(BasicTypeCode.BT_HANDLE);
    }

    public static SemType getFutureType() {
        return Builder.from(BasicTypeCode.BT_FUTURE);
    }

    public static SemType getRegexType() {
        return Builder.from(BasicTypeCode.BT_REGEXP);
    }

    public static SemType getTypeDescType() {
        return Builder.from(BasicTypeCode.BT_TYPEDESC);
    }

    public static SemType getStreamType() {
        return Builder.from(BasicTypeCode.BT_STREAM);
    }

    public static SemType getAnyDataType() {
        return ANYDATA.get();
    }

    public static SemType getObjectType() {
        return OBJECT;
    }

    public static SemType getInherentlyImmutable() {
        return INHERENTLY_IMMUTABLE;
    }

    static SemType mappingRO() {
        return MAPPING_RO.get();
    }

    static SemType innerReadOnly() {
        return INNER_RO.get();
    }

    static CellAtomicType cellAtomicVal() {
        return PREDEFINED_TYPE_ENV.cellAtomicVal();
    }

    public static BddNode getBddSubtypeRo() {
        return BddNode.bddAtom(RecAtom.createUnBlockedRecAtom(0));
    }

    public static ListAtomicType getListAtomicInner() {
        return LIST_ATOMIC_INNER.get();
    }

    public static MappingAtomicType getMappingAtomicInner() {
        return MAPPING_ATOMIC_INNER.get();
    }

    public static BddNode getListSubtypeThreeElement() {
        return LIST_SUBTYPE_THREE_ELEMENT;
    }

    public static BddNode getListSubtypeThreeElementRO() {
        return LIST_SUBTYPE_THREE_ELEMENT_RO;
    }

    public static BddNode getListSubtypeTwoElement() {
        return LIST_SUBTYPE_TWO_ELEMENT;
    }

    public static SemType getSimpleOrStringType() {
        return SIMPLE_OR_STRING;
    }

    public static SemType getTableType() {
        return Builder.from(BasicTypeCode.BT_TABLE);
    }

    private static final class BasicTypeCache {
        private static final SemType[] cache = new SemType[21];

        private BasicTypeCache() {
        }

        static {
            for (int i = 0; i < 20; ++i) {
                BasicTypeCache.cache[i] = SemType.from(1 << i);
            }
        }
    }

    private static final class StringTypeCache {
        private static final Interner<String> interner = Interner.newWeakInterner();
        private static final SemType charType;

        private StringTypeCache() {
        }

        static {
            BStringSubType subTypeData = BStringSubType.createStringSubType(false, EMPTY_STRING_ARR, true, EMPTY_STRING_ARR);
            charType = Builder.basicSubType(BasicTypeCode.BT_STRING, subTypeData);
        }
    }

    private static final class IntTypeCache {
        private static final int CACHE_MAX_VALUE = 127;
        private static final int CACHE_MIN_VALUE = -128;
        private static final SemType[] cache = new SemType[256];

        private IntTypeCache() {
        }

        static {
            for (int i = -128; i <= 127; ++i) {
                IntTypeCache.cache[i - -128] = Builder.createIntSingletonType(i);
            }
        }
    }

    private static final class BooleanTypeCache {
        private static final SemType TRUE = BooleanTypeCache.createBooleanSingletonType(true);
        private static final SemType FALSE = BooleanTypeCache.createBooleanSingletonType(false);

        private BooleanTypeCache() {
        }

        private static SemType createBooleanSingletonType(boolean value) {
            return Builder.basicSubType(BasicTypeCode.BT_BOOLEAN, BBooleanSubType.from(value));
        }
    }
}

