/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.semtype.MutableSemType;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TypeCheckLogger {
    private static final TypeCheckLogger instance = new TypeCheckLogger();
    private final boolean enabled;
    private final Logger logger;

    private TypeCheckLogger() {
        String diagnosticEnable = System.getenv("BAL_LOG_TYPE_CHECK");
        if ("true".equalsIgnoreCase(diagnosticEnable)) {
            this.enabled = true;
            this.logger = new Logger(this, TypeCheckLogger.getConfig());
        } else {
            this.enabled = false;
            this.logger = null;
        }
    }

    public static TypeCheckLogger getInstance() {
        return instance;
    }

    public void typeCreatedDynamically(Type type) {
        if (this.enabled) {
            this.logger.info("Type created dynamically: " + String.valueOf(type));
        }
    }

    public void typeResolutionStarted(MutableSemType type) {
        if (this.enabled) {
            this.logger.info("Type resolution started: " + String.valueOf(type));
        }
    }

    public void typeResolutionDone(MutableSemType type) {
        if (this.enabled) {
            this.logger.info("Type resolution done: " + String.valueOf(type));
        }
    }

    public void shapeCheckStarted(Object value, Type type) {
        if (this.enabled) {
            Context cx = TypeChecker.context();
            this.logger.info("Shape check started: " + String.valueOf(cx) + ", value: " + String.valueOf(value) + ", type: " + String.valueOf(type));
        }
    }

    public void shapeCheckDone(Object value, Type type, boolean result) {
        if (this.enabled) {
            Context cx = TypeChecker.context();
            this.logger.info("Shape check done: " + String.valueOf(cx) + ", value: " + String.valueOf(value) + ", type: " + String.valueOf(type) + ", result: " + result);
        }
    }

    public void typeCheckStarted(Context cx, Type t1, Type t2) {
        if (this.enabled) {
            this.logger.info("Type check started: " + String.valueOf(cx) + ", t1: " + String.valueOf(t1) + ", t2: " + String.valueOf(t2));
        }
    }

    public void typeCheckCachedResult(Context cx, Type t1, Type t2, Boolean result) {
        if (this.enabled) {
            this.logger.info("Type check cached result: " + String.valueOf(cx) + ", t1: " + String.valueOf(t1) + ", t2: " + String.valueOf(t2) + ", result: " + result);
        }
    }

    public void semTypeCheckStarted(Context cx, SemType t1, SemType t2) {
        if (this.enabled) {
            this.logger.info("SemType check started: " + String.valueOf(cx) + ", t1: " + String.valueOf(t1) + ", t2: " + String.valueOf(t2));
        }
    }

    public void semTypeCheckDone(Context cx, SemType t1, SemType t2, boolean result) {
        if (this.enabled) {
            this.logger.info("SemType check done: " + String.valueOf(cx) + ", t1: " + String.valueOf(t1) + ", t2: " + String.valueOf(t2) + ", result: " + result);
        }
    }

    public void typeCheckDone(Context cx, Type t1, Type t2, boolean result) {
        if (this.enabled) {
            this.logger.info("Type check done: " + String.valueOf(cx) + ", t1: " + String.valueOf(t1) + ", t2: " + String.valueOf(t2) + ", result: " + result);
        }
    }

    private static LogConfig getConfig() {
        boolean isSilent;
        String logPath = System.getenv("BAL_LOG_TYPE_CHECK_PATH");
        boolean bl = isSilent = System.getenv("BAL_LOG_TYPE_CHECK_SILENT") != null;
        if (logPath == null) {
            if (isSilent) {
                throw new IllegalArgumentException("Type check logging is enabled but set to silent and no log path provided");
            }
            return new LogConfig(Optional.empty(), false);
        }
        return new LogConfig(Optional.of(logPath), isSilent);
    }

    private final class Logger {
        private final FileWritter fileWritter;
        private final ConsoleWriter consoleWriter;

        private Logger(TypeCheckLogger typeCheckLogger, LogConfig config) {
            this.fileWritter = config.filePath().map(x$0 -> new FileWritter(this, (String)x$0)).orElse(null);
            this.consoleWriter = !config.isSilent ? new ConsoleWriter() : null;
        }

        public void info(String message) {
            String formattedMessage = String.format("[INFO] [%d] %s", System.nanoTime(), message);
            Logger.writeIfAvailable(this.fileWritter, formattedMessage);
            Logger.writeIfAvailable(this.consoleWriter, formattedMessage);
        }

        private static void writeIfAvailable(Writer writer, String message) {
            if (writer != null) {
                writer.write(message);
            }
        }

        private final class FileWritter
        implements Writer {
            private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

            private FileWritter(Logger logger, String filePath) {
                Thread thread = new Thread(() -> {
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath, true));){
                        this.flushToBuffer(writer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Log write failed due to: ", e);
                    }
                });
                thread.setDaemon(true);
                thread.start();
            }

            private void flushToBuffer(BufferedWriter writer) throws IOException {
                try {
                    while (true) {
                        String message = this.queue.take();
                        writer.write(message);
                        writer.newLine();
                        writer.flush();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }

            @Override
            public void write(String message) {
                this.queue.add(message);
            }
        }

        private static final class ConsoleWriter
        implements Writer {
            private static final PrintStream outputStream = System.out;

            private ConsoleWriter() {
            }

            @Override
            public void write(String message) {
                outputStream.println(message);
            }
        }

        private static interface Writer {
            public void write(String var1);
        }
    }

    record LogConfig(Optional<String> filePath, boolean isSilent) {
    }
}

