/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.DecimalType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.DecimalValue;
import java.math.BigDecimal;
import java.util.function.Supplier;

public final class BDecimalType
extends BSemTypeWrapper<BDecimalTypeImpl>
implements DecimalType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getDecimalType();
    private static final BDecimalTypeImpl DEFAULT_B_TYPE = new BDecimalTypeImpl("decimal", PredefinedTypes.EMPTY_MODULE);
    private final SemType shape;

    public BDecimalType(String typeName, Module pkg) {
        this(() -> new BDecimalTypeImpl(typeName, pkg), typeName, pkg, Builder.getDecimalType());
    }

    public static BDecimalType singletonType(BigDecimal value) {
        return new BDecimalType(() -> (BDecimalTypeImpl)DEFAULT_B_TYPE.clone(), "decimal", PredefinedTypes.EMPTY_MODULE, Builder.getDecimalConst(value));
    }

    private BDecimalType(Supplier<BDecimalTypeImpl> bType, String typeName, Module pkg, SemType semType) {
        super(new ConcurrentLazySupplier<BDecimalTypeImpl>(bType), typeName, pkg, 4, semType);
        this.shape = semType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    public SemType shape() {
        return this.shape;
    }

    protected static final class BDecimalTypeImpl
    extends BType
    implements DecimalType,
    Cloneable {
        private BDecimalTypeImpl(String typeName, Module pkg) {
            super(typeName, pkg, DecimalValue.class, false);
        }

        @Override
        public <V> V getZeroValue() {
            return (V)new DecimalValue(BigDecimal.ZERO);
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)new DecimalValue(BigDecimal.ZERO);
        }

        @Override
        public int getTag() {
            return 4;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }

        @Override
        public BType clone() {
            return super.clone();
        }
    }
}

