/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.IntegerType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.ConcurrentLazySupplier;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BSemTypeWrapper;
import io.ballerina.runtime.internal.types.BType;
import java.util.function.Supplier;

public final class BIntegerType
extends BSemTypeWrapper<BIntegerTypeImpl>
implements IntegerType {
    private static final BasicTypeBitSet BASIC_TYPE_BIT_SET = Builder.getIntType();
    private static final BIntegerTypeImpl DEFAULT_B_TYPE = new BIntegerTypeImpl("int", PredefinedTypes.EMPTY_MODULE, 1);

    public BIntegerType(String typeName, Module pkg) {
        this(() -> new BIntegerTypeImpl(typeName, pkg, 1), typeName, pkg, 1, Builder.getIntType());
    }

    public BIntegerType(String typeName, Module pkg, int tag) {
        this(() -> new BIntegerTypeImpl(typeName, pkg, tag), typeName, pkg, tag, BIntegerType.pickSemType(tag));
    }

    private BIntegerType(Supplier<BIntegerTypeImpl> bIntegerTypeSupplier, String typeName, Module pkg, int tag, SemType semType) {
        super(new ConcurrentLazySupplier<BIntegerTypeImpl>(bIntegerTypeSupplier), typeName, pkg, tag, semType);
    }

    private static SemType pickSemType(int tag) {
        return switch (tag) {
            case 1 -> Builder.getIntType();
            case 7 -> Builder.createIntRange(RuntimeConstants.SIGNED8_MIN_VALUE.intValue(), RuntimeConstants.SIGNED8_MAX_VALUE.intValue());
            case 9 -> Builder.createIntRange(RuntimeConstants.SIGNED16_MIN_VALUE.intValue(), RuntimeConstants.SIGNED16_MAX_VALUE.intValue());
            case 11 -> Builder.createIntRange(RuntimeConstants.SIGNED32_MIN_VALUE.intValue(), RuntimeConstants.SIGNED32_MAX_VALUE.intValue());
            case 2, 8 -> Builder.createIntRange(0L, RuntimeConstants.UNSIGNED8_MAX_VALUE.intValue());
            case 10 -> Builder.createIntRange(0L, RuntimeConstants.UNSIGNED16_MAX_VALUE.intValue());
            case 12 -> Builder.createIntRange(0L, RuntimeConstants.UNSIGNED32_MAX_VALUE);
            default -> throw new UnsupportedOperationException("Unexpected int tag");
        };
    }

    public static BIntegerType singletonType(long value) {
        if (value >= -128L && value <= 127L) {
            return IntegerTypeCache.cache[(int)value - -128];
        }
        return BIntegerType.createSingletonType(value);
    }

    private static BIntegerType createSingletonType(long value) {
        return new BIntegerType(() -> (BIntegerTypeImpl)DEFAULT_B_TYPE.clone(), "int", PredefinedTypes.EMPTY_MODULE, 1, Builder.getIntConst(value));
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE_BIT_SET;
    }

    private static final class IntegerTypeCache {
        private static final BIntegerType[] cache = new BIntegerType[256];
        private static final int CACHE_MAX_VALUE = 127;
        private static final int CACHE_MIN_VALUE = -128;

        private IntegerTypeCache() {
        }

        static {
            for (int i = -128; i <= 127; ++i) {
                IntegerTypeCache.cache[i - -128] = BIntegerType.createSingletonType(i);
            }
        }
    }

    protected static final class BIntegerTypeImpl
    extends BType
    implements IntegerType,
    Cloneable {
        private final int tag;

        private BIntegerTypeImpl(String typeName, Module pkg, int tag) {
            super(typeName, pkg, Long.class, false);
            this.tag = tag;
        }

        @Override
        public <V> V getZeroValue() {
            return (V)new Long(0L);
        }

        @Override
        public <V> V getEmptyValue() {
            return (V)new Long(0L);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE_BIT_SET;
        }

        @Override
        public BType clone() {
            return super.clone();
        }
    }
}

