/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BAnyType;
import io.ballerina.runtime.internal.types.BBooleanType;
import io.ballerina.runtime.internal.types.BByteType;
import io.ballerina.runtime.internal.types.BDecimalType;
import io.ballerina.runtime.internal.types.BFloatType;
import io.ballerina.runtime.internal.types.BHandleType;
import io.ballerina.runtime.internal.types.BIntegerType;
import io.ballerina.runtime.internal.types.BNullType;
import io.ballerina.runtime.internal.types.BReadonlyType;
import io.ballerina.runtime.internal.types.BStringType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.semtype.ImmutableSemType;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public abstract sealed class BSemTypeWrapper<E extends BType>
extends ImmutableSemType
implements Type,
MayBeDependentType
permits BAnyType, BBooleanType, BByteType, BDecimalType, BFloatType, BHandleType, BIntegerType, BNullType, BReadonlyType, BStringType {
    private Type cachedReferredType = null;
    private Type cachedImpliedType = null;
    private final Supplier<E> bTypeSupplier;
    private final int tag;
    protected final String typeName;
    private final Module pkg;

    protected BSemTypeWrapper(Supplier<E> bTypeSupplier, String typeName, Module pkg, int tag, SemType semType) {
        super(semType);
        this.bTypeSupplier = bTypeSupplier;
        this.typeName = typeName;
        this.tag = tag;
        this.pkg = pkg;
    }

    public final <V> Class<V> getValueClass() {
        return ((BType)this.getbType()).getValueClass();
    }

    @Override
    public final <V> V getZeroValue() {
        return ((BType)this.getbType()).getZeroValue();
    }

    @Override
    public final <V> V getEmptyValue() {
        return ((BType)this.getbType()).getEmptyValue();
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    @Override
    public final String toString() {
        return ((BType)this.getbType()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BSemTypeWrapper)) {
            return false;
        }
        BSemTypeWrapper other = (BSemTypeWrapper)obj;
        return Objects.equals(this.typeName, other.typeName) && Objects.equals(this.pkg, other.pkg);
    }

    @Override
    public final boolean isNilable() {
        return Core.containsBasicType(this, Builder.getNilType());
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.typeName, this.pkg);
    }

    @Override
    public String getName() {
        return this.typeName == null ? "" : this.typeName;
    }

    @Override
    public String getQualifiedName() {
        String name = this.getName();
        if (name.isEmpty()) {
            return "";
        }
        return this.pkg == null ? name : String.valueOf(this.pkg) + ":" + name;
    }

    @Override
    public Module getPackage() {
        return this.pkg;
    }

    @Override
    public boolean isPublic() {
        return ((BType)this.getbType()).isPublic();
    }

    @Override
    public boolean isNative() {
        return ((BType)this.getbType()).isNative();
    }

    @Override
    public boolean isAnydata() {
        return Core.isSubtypeSimple(this, Builder.getAnyDataType());
    }

    @Override
    public boolean isPureType() {
        return Core.isSubtypeSimple(this, Builder.getErrorType()) || this.isAnydata();
    }

    @Override
    public boolean isReadOnly() {
        if (Core.isSubtypeSimple(this, Builder.getInherentlyImmutable())) {
            return true;
        }
        Context cx = TypeChecker.context();
        return Core.isSubType(cx, this, Builder.getReadonlyType());
    }

    @Override
    public Type getImmutableType() {
        return ((BType)this.getbType()).getImmutableType();
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        ((BType)this.getbType()).setImmutableType(immutableType);
    }

    @Override
    public Module getPkg() {
        return this.pkg;
    }

    @Override
    public long getFlags() {
        return ((BType)this.getbType()).getFlags();
    }

    @Override
    public void setCachedReferredType(Type type) {
        this.cachedReferredType = type;
    }

    @Override
    public Type getCachedReferredType() {
        return this.cachedReferredType;
    }

    @Override
    public void setCachedImpliedType(Type type) {
        this.cachedImpliedType = type;
    }

    @Override
    public Type getCachedImpliedType() {
        return this.cachedImpliedType;
    }

    protected E getbType() {
        return (E)((BType)this.bTypeSupplier.get());
    }

    @Override
    public boolean isDependentlyTyped() {
        return false;
    }

    @Override
    public boolean isDependentlyTyped(Set<MayBeDependentType> visited) {
        return this.isDependentlyTyped();
    }
}

