/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypedescType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.SimpleTypeCheckFlyweightStore;
import io.ballerina.runtime.internal.types.semtype.TypedescUtils;
import io.ballerina.runtime.internal.values.TypedescValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.Set;

public class BTypedescType
extends BType
implements TypedescType {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getTypeDescType();
    private static final SimpleTypeCheckFlyweightStore FLYWEIGHT_CACHE = new SimpleTypeCheckFlyweightStore();
    private final Type constraint;

    public BTypedescType(String typeName, Module pkg) {
        super(typeName, pkg, Object.class, true);
        this.constraint = null;
    }

    public BTypedescType(Type constraint) {
        super("typedesc", null, TypedescValue.class, false);
        this.constraint = constraint;
        SimpleTypeCheckFlyweightStore.TypeCheckFlyweight flyweight = FLYWEIGHT_CACHE.get(constraint);
        this.typeCheckCache = flyweight.typeCheckCache();
        this.typeId = flyweight.typeId();
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TypedescValueImpl(PredefinedTypes.TYPE_NULL);
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 25;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BTypedescType) {
            BTypedescType typedescType = (BTypedescType)obj;
            return this.constraint.equals(typedescType.getConstraint());
        }
        return false;
    }

    @Override
    public Type getConstraint() {
        return this.constraint;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public String toString() {
        return "typedesc<" + this.constraint.toString() + ">";
    }

    @Override
    public SemType createSemType(Context cx) {
        if (this.constraint == null) {
            return Builder.getTypeDescType();
        }
        SemType constraint = BTypedescType.tryInto(cx, this.getConstraint());
        return TypedescUtils.typedescContaining(cx.env, constraint);
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType constraintType;
        Type type = this.constraint;
        return type instanceof MayBeDependentType && (constraintType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }
}

