/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.FlyweightLookupTable;
import io.ballerina.runtime.internal.types.semtype.TypeCheckCacheFlyweight;

class TypeCheckFlyweightStore<E extends Definition> {
    private final FlyweightLookupTable<E> cacheRO = new FlyweightLookupTable(this::create);
    private final FlyweightLookupTable<E> cacheRW = new FlyweightLookupTable(this::create);

    TypeCheckFlyweightStore() {
    }

    private TypeCheckCacheFlyweight<E> create(int constraintId) {
        int typeId = switch (TypeIdSupplier.kind(constraintId)) {
            default -> throw new MatchException(null, null);
            case TypeIdSupplier.IdKind.RESERVED -> TypeIdSupplier.getReservedId();
            case TypeIdSupplier.IdKind.NAMED -> TypeIdSupplier.getNamedId();
            case TypeIdSupplier.IdKind.UNNAMED -> TypeIdSupplier.getAnonId();
        };
        TypeCheckCache typeCheckCache = TypeCheckCacheFactory.create();
        return new TypeCheckCacheFlyweight(typeId, typeCheckCache);
    }

    private TypeCheckCacheFlyweight<E> create() {
        int typeId = TypeIdSupplier.getAnonId();
        TypeCheckCache typeCheckCache = TypeCheckCacheFactory.create();
        return new TypeCheckCacheFlyweight(typeId, typeCheckCache);
    }

    public TypeCheckCacheFlyweight<E> getRO(Type constraint) {
        return this.get(this.cacheRO, constraint);
    }

    public TypeCheckCacheFlyweight<E> getRW(Type constraint) {
        return this.get(this.cacheRW, constraint);
    }

    private TypeCheckCacheFlyweight<E> get(FlyweightLookupTable<E> lookupTable, Type constraint) {
        if (constraint instanceof CacheableTypeDescriptor) {
            CacheableTypeDescriptor cacheableTypeDescriptor = (CacheableTypeDescriptor)constraint;
            return lookupTable.get(cacheableTypeDescriptor.typeId());
        }
        return this.create();
    }
}

