/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Interner;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;

public class CacheFactory {
    private static final int DEFAULT_EXPIRE_TIME = 10;
    private static final int INITIAL_CAPACITY = 10000;
    private static final Caffeine<Object, Object> identityCacheBuilder = Caffeine.newBuilder().weakKeys().initialCapacity(10000);
    private static final Caffeine<Object, Object> cacheBuilder = Caffeine.newBuilder().maximumSize(10000L).initialCapacity(10000);

    private CacheFactory() {
    }

    public static <K, V> LoadingCache<K, V> createCache(CacheLoader<K, V> loader) {
        return cacheBuilder.build(loader);
    }

    public static <K, V> Cache<K, V> createCache() {
        return cacheBuilder.build();
    }

    public static <K, V> LoadingCache<K, V> createIdentityCache(CacheLoader<K, V> loader) {
        return identityCacheBuilder.build(loader);
    }

    public static <K, V> Map<K, V> createCachingHashMap() {
        return new HashMap(10000);
    }

    public static <E> Interner<E> createInterner() {
        return Interner.newStrongInterner();
    }
}

