/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.AtomicType;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeAtom;
import java.util.HashMap;
import java.util.Map;

public record CellAtomicType(SemType ty, CellMutability mut) implements AtomicType
{
    public CellAtomicType {
        assert (ty != null);
    }

    public static CellAtomicType from(SemType ty, CellMutability mut) {
        return CellAtomCache.get(ty, mut);
    }

    public static CellAtomicType intersectCellAtomicType(CellAtomicType c1, CellAtomicType c2) {
        SemType ty = Core.intersect(c1.ty(), c2.ty());
        CellMutability mut = CellAtomicType.min(c1.mut(), c2.mut());
        return CellAtomicType.from(ty, mut);
    }

    private static CellMutability min(CellMutability m1, CellMutability m2) {
        return m1.compareTo(m2) <= 0 ? m1 : m2;
    }

    public static CellAtomicType cellAtomType(Atom atom) {
        return (CellAtomicType)((TypeAtom)atom).atomicType();
    }

    public static enum CellMutability {
        CELL_MUT_NONE,
        CELL_MUT_LIMITED,
        CELL_MUT_UNLIMITED;

    }

    private static final class CellAtomCache {
        private static final Map<Integer, CellAtomicType> NONE_CACHE = new HashMap<Integer, CellAtomicType>();
        private static final Map<Integer, CellAtomicType> LIMITED_CACHE = new HashMap<Integer, CellAtomicType>();
        private static final Map<Integer, CellAtomicType> UNLIMITED_CACHE = new HashMap<Integer, CellAtomicType>();

        private CellAtomCache() {
        }

        private static CellAtomicType get(SemType semType, CellMutability mut) {
            if (semType.some() != 0) {
                return new CellAtomicType(semType, mut);
            }
            int key = semType.all();
            return switch (mut.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NONE_CACHE.computeIfAbsent(key, ignored -> new CellAtomicType(semType, mut));
                case 1 -> LIMITED_CACHE.computeIfAbsent(key, ignored -> new CellAtomicType(semType, mut));
                case 2 -> UNLIMITED_CACHE.computeIfAbsent(key, ignored -> new CellAtomicType(semType, mut));
            };
        }
    }
}

