/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import java.util.Arrays;
import java.util.List;

public abstract class EnumerableSubtypeData<E extends Comparable<E>> {
    public abstract boolean allowed();

    public abstract E[] values();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumerableSubtypeData)) {
            return false;
        }
        EnumerableSubtypeData other = (EnumerableSubtypeData)obj;
        return other.allowed() == this.allowed() && Arrays.equals(other.values(), this.values());
    }

    public int hashCode() {
        return super.hashCode();
    }

    boolean union(EnumerableSubtypeData<E> other, List<E> results) {
        boolean b1 = this.allowed();
        boolean b2 = other.allowed();
        if (b1 && b2) {
            EnumerableSubtypeData.enumerableListUnion((Comparable[])this.values(), (Comparable[])other.values(), results);
            return true;
        }
        if (!b1 && !b2) {
            EnumerableSubtypeData.enumerableListIntersection((Comparable[])this.values(), (Comparable[])other.values(), results);
            return false;
        }
        if (b1 && !b2) {
            EnumerableSubtypeData.enumerableListDiff((Comparable[])other.values(), (Comparable[])this.values(), results);
            return false;
        }
        EnumerableSubtypeData.enumerableListDiff((Comparable[])this.values(), (Comparable[])other.values(), results);
        return false;
    }

    boolean intersect(EnumerableSubtypeData<E> other, List<E> results) {
        boolean b1 = this.allowed();
        boolean b2 = other.allowed();
        if (b1 && b2) {
            EnumerableSubtypeData.enumerableListIntersection((Comparable[])this.values(), (Comparable[])other.values(), results);
            return true;
        }
        if (!b1 && !b2) {
            EnumerableSubtypeData.enumerableListUnion((Comparable[])this.values(), (Comparable[])other.values(), results);
            return false;
        }
        if (b1 && !b2) {
            EnumerableSubtypeData.enumerableListDiff((Comparable[])this.values(), (Comparable[])other.values(), results);
            return true;
        }
        EnumerableSubtypeData.enumerableListDiff((Comparable[])other.values(), (Comparable[])this.values(), results);
        return true;
    }

    private static <E extends Comparable<E>> void enumerableListUnion(E[] values1, E[] values2, List<E> results) {
        int i2 = 0;
        int i1 = 0;
        int len1 = values1.length;
        int len2 = values2.length;
        while (true) {
            if (i1 >= len1) {
                if (i2 >= len2) break;
                results.add(values2[i2]);
                ++i2;
                continue;
            }
            if (i2 >= len2) {
                results.add(values1[i1]);
                ++i1;
                continue;
            }
            E s1 = values1[i1];
            E s2 = values2[i2];
            int result = s1.compareTo(s2);
            if (result == 0) {
                results.add(s1);
                ++i1;
                ++i2;
                continue;
            }
            if (result < 0) {
                results.add(s1);
                ++i1;
                continue;
            }
            results.add(s2);
            ++i2;
        }
    }

    private static <E extends Comparable<E>> void enumerableListIntersection(E[] v1, E[] v2, List<E> results) {
        int i2 = 0;
        int i1 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (i1 < len1 && i2 < len2) {
            E s1 = v1[i1];
            E s2 = v2[i2];
            int result = s1.compareTo(s2);
            if (result == 0) {
                results.add(s1);
                ++i1;
                ++i2;
                continue;
            }
            if (result < 0) {
                ++i1;
                continue;
            }
            ++i2;
        }
    }

    private static <E extends Comparable<E>> void enumerableListDiff(E[] t1, E[] t2, List<E> results) {
        int i2 = 0;
        int i1 = 0;
        int len1 = t1.length;
        int len2 = t2.length;
        while (i1 < len1) {
            if (i2 >= len2) {
                results.add(t1[i1]);
                ++i1;
                continue;
            }
            E s1 = t1[i1];
            E s2 = t2[i2];
            int result = s1.compareTo(s2);
            if (result == 0) {
                ++i1;
                ++i2;
                continue;
            }
            if (result < 0) {
                results.add(s1);
                ++i1;
                continue;
            }
            ++i2;
        }
    }
}

