/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;

public class StreamDefinition
extends Definition {
    private final ListDefinition listDefinition = new ListDefinition();

    @Override
    public SemType getSemType(Env env) {
        return this.streamContaining(this.listDefinition.getSemType(env));
    }

    public SemType define(Env env, SemType valueType, SemType completionType) {
        if (Builder.getValType() == completionType && Builder.getValType() == valueType) {
            return Builder.getStreamType();
        }
        SemType tuple = this.listDefinition.defineListTypeWrapped(env, new SemType[]{valueType, completionType}, 2, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        return this.streamContaining(tuple);
    }

    private SemType streamContaining(SemType tupleType) {
        SubTypeData bdd = Core.subTypeData(tupleType, BasicTypeCode.BT_LIST);
        assert (bdd instanceof Bdd);
        return Core.createBasicSemType(BasicTypeCode.BT_STREAM, (Bdd)bdd);
    }
}

