/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.FixedLengthArray;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import java.util.Optional;

public final class TableUtils {
    private static final SemType[] EMPTY_SEMTYPE_ARR = new SemType[0];

    private TableUtils() {
    }

    public static SemType acceptedTypeContainingKeySpecifier(Context cx, SemType tableConstraint, String[] fieldNames) {
        return TableUtils.tableContainingKeySpecifierInner(fieldNames, cx, tableConstraint, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    public static SemType tableContainingKeySpecifier(Context cx, SemType tableConstraint, String[] fieldNames) {
        return TableUtils.tableContainingKeySpecifierInner(fieldNames, cx, tableConstraint, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    private static SemType tableContainingKeySpecifierInner(String[] fieldNames, Context cx, SemType tableConstraint, CellAtomicType.CellMutability cellMutLimited) {
        SemType[] fieldNameSingletons = new SemType[fieldNames.length];
        SemType[] fieldTypes = new SemType[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            SemType key;
            fieldNameSingletons[i] = key = Builder.getStringConst(fieldNames[i]);
            fieldTypes[i] = Core.mappingMemberTypeInnerVal(cx, tableConstraint, key);
        }
        SemType normalizedKs = new ListDefinition().defineListTypeWrapped(cx.env, fieldNameSingletons, fieldNameSingletons.length, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_NONE);
        SemType normalizedKc = fieldNames.length > 1 ? new ListDefinition().defineListTypeWrapped(cx.env, fieldTypes, fieldTypes.length, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_NONE) : fieldTypes[0];
        return TableUtils.tableContaining(cx.env, tableConstraint, normalizedKc, normalizedKs, cellMutLimited);
    }

    public static SemType acceptedTypeContainingKeyConstraint(Context cx, SemType tableConstraint, SemType keyConstraint) {
        return TableUtils.tableContainingKeyConstraintInner(cx, tableConstraint, keyConstraint, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    public static SemType tableContainingKeyConstraint(Context cx, SemType tableConstraint, SemType keyConstraint) {
        return TableUtils.tableContainingKeyConstraintInner(cx, tableConstraint, keyConstraint, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    private static SemType tableContainingKeyConstraintInner(Context cx, SemType tableConstraint, SemType keyConstraint, CellAtomicType.CellMutability mut) {
        Optional<ListAtomicType> lat = Core.listAtomicType(cx, keyConstraint);
        SemType normalizedKc = lat.map(atom -> {
            FixedLengthArray member = atom.members();
            return switch (member.fixedLength()) {
                case 0 -> Builder.getValType();
                case 1 -> Core.cellAtomicType(member.initial()[0]).orElseThrow().ty();
                default -> keyConstraint;
            };
        }).orElse(keyConstraint);
        return TableUtils.tableContaining(cx.env, tableConstraint, normalizedKc, Builder.getValType(), mut);
    }

    public static SemType tableContaining(Env env, SemType tableConstraint) {
        return TableUtils.tableContaining(env, tableConstraint, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public static SemType acceptedType(Env env, SemType tableConstraint) {
        return TableUtils.tableContaining(env, tableConstraint, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    private static SemType tableContaining(Env env, SemType tableConstraint, CellAtomicType.CellMutability mut) {
        return TableUtils.tableContaining(env, tableConstraint, Builder.getValType(), Builder.getValType(), mut);
    }

    private static SemType tableContaining(Env env, SemType tableConstraint, SemType normalizedKc, SemType normalizedKs, CellAtomicType.CellMutability mut) {
        tableConstraint = Core.intersect(tableConstraint, Builder.getMappingType());
        ListDefinition typeParamArrDef = new ListDefinition();
        SemType typeParamArray = typeParamArrDef.defineListTypeWrapped(env, EMPTY_SEMTYPE_ARR, 0, tableConstraint, mut);
        ListDefinition listDef = new ListDefinition();
        SemType tupleType = listDef.defineListTypeWrapped(env, new SemType[]{typeParamArray, normalizedKc, normalizedKs}, 3, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        Bdd bdd = (Bdd)Core.subTypeData(tupleType, BasicTypeCode.BT_LIST);
        return Core.createBasicSemType(BasicTypeCode.BT_TABLE, bdd);
    }
}

