/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.RegExpCommonValue;
import io.ballerina.runtime.internal.values.RegExpTerm;
import java.util.StringJoiner;

public class RegExpSequence
extends RegExpCommonValue {
    private final RegExpTerm[] termsList;

    public RegExpSequence(ArrayValue termsList) {
        this.termsList = this.getRegExpSeqList(termsList);
    }

    public RegExpSequence(RegExpTerm[] termsList) {
        this.termsList = termsList;
    }

    public RegExpTerm[] getRegExpTermsList() {
        return this.termsList;
    }

    private RegExpTerm[] getRegExpSeqList(ArrayValue seqList) {
        int size = seqList.size();
        RegExpTerm[] terms = new RegExpTerm[size];
        for (int i = 0; i < size; ++i) {
            terms[i] = (RegExpTerm)seqList.get(i);
        }
        return terms;
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner terms = new StringJoiner("");
        for (RegExpTerm t : this.termsList) {
            terms.add(t.stringValue(parent));
        }
        return terms.toString();
    }
}

