/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.tracer.BSpan;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObserverContext {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Tag> tags = new HashMap<String, Tag>();
    public Map<String, Tag> customMetricTags;
    private BSpan span;
    private String entrypointFunctionModule;
    private String entrypointServiceName;
    private String entrypointFunctionName;
    private String entrypointResourceAccessor;
    private String serviceName;
    private String operationName;
    private boolean server;
    private boolean started;
    private boolean finished;
    private ObserverContext parent;
    private boolean isSystemSpan;
    private boolean manuallyClosed;

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void addTag(String key, String value) {
        String sanitizedValue = value != null ? value : "";
        Tag tag = Tag.of(key, sanitizedValue);
        this.tags.put(key, tag);
    }

    public Tag getTag(String key) {
        return this.tags.get(key);
    }

    public Set<Tag> getAllTags() {
        return new HashSet<Tag>(this.tags.values());
    }

    public BSpan getSpan() {
        return this.span;
    }

    public void setSpan(BSpan span) {
        this.span = span;
    }

    public String getEntrypointFunctionModule() {
        return this.entrypointFunctionModule;
    }

    public void setEntrypointFunctionModule(String entrypointFunctionModule) {
        this.entrypointFunctionModule = entrypointFunctionModule;
    }

    public String getEntrypointServiceName() {
        return this.entrypointServiceName;
    }

    public void setEntrypointServiceName(String entrypointServiceName) {
        this.entrypointServiceName = entrypointServiceName;
    }

    public String getEntrypointFunctionName() {
        return this.entrypointFunctionName;
    }

    public void setEntrypointFunctionName(String entrypointFunctionName) {
        this.entrypointFunctionName = entrypointFunctionName;
    }

    public String getEntrypointResourceAccessor() {
        return this.entrypointResourceAccessor;
    }

    public void setEntrypointResourceAccessor(String entrypointResourceAccessor) {
        this.entrypointResourceAccessor = entrypointResourceAccessor;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public boolean isServer() {
        return this.server;
    }

    void setServer() {
        this.server = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    void setStarted() {
        this.started = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    public ObserverContext getParent() {
        return this.parent;
    }

    public void setParent(ObserverContext parent) {
        this.parent = parent;
    }

    public boolean isSystemSpan() {
        return this.isSystemSpan;
    }

    public void setSystemSpan(boolean userSpan) {
        this.isSystemSpan = userSpan;
    }

    public boolean isManuallyClosed() {
        return this.manuallyClosed;
    }

    public void setManuallyClosed(boolean manuallyClosed) {
        this.manuallyClosed = manuallyClosed;
    }

    @Deprecated
    public void setObjectName(String objectName) {
        this.addTag("listener.name", objectName);
    }
}

