/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.runtime;

import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.profiler.runtime.Data;
import io.ballerina.runtime.profiler.runtime.ProfilerRuntimeException;
import io.ballerina.runtime.profiler.runtime.StackTraceMap;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class ProfileAnalyzer {
    private final ConcurrentHashMap<String, Data> profiles = new ConcurrentHashMap();

    public static ProfileAnalyzer getInstance() {
        return ProfilerHolder.PROFILER_INSTANCE;
    }

    private ProfileAnalyzer() {
        this.addProfilerShutDownHook();
    }

    public Data start(Strand strand, String className, String methodName) {
        Data data;
        Object stacksObj = strand.getProperty("b7a.profile.stack");
        String stackIndex = StackTraceMap.getStackIndex(className + "." + methodName) + "$";
        String stackKey = stacksObj != null ? String.valueOf(stacksObj) + stackIndex : stackIndex;
        if (this.profiles.containsKey(stackKey)) {
            data = this.profiles.get(stackKey);
        } else {
            data = new Data(stackIndex, stackKey);
            this.profiles.put(stackKey, data);
        }
        data.start(String.valueOf(strand.getId()));
        strand.setProperty("b7a.profile.stack", stackKey);
        return data;
    }

    public void stop(Strand strand, Data data) {
        data.stop(String.valueOf(strand.getId()));
        strand.setProperty("b7a.profile.stack", data.stackKey.substring(0, data.stackKey.length() - data.stackIndex.length()));
    }

    public final String getProfileStackString() {
        StringBuilder sb = new StringBuilder("[");
        ArrayList<Data> dataList = new ArrayList<Data>(this.profiles.values());
        for (int i = 0; i < dataList.size() - 1; ++i) {
            Data data = dataList.get(i);
            data.stackTrace = StackTraceMap.getCallStackString(data.stackKey);
            sb.append(data).append(",\n");
        }
        Data data = dataList.get(dataList.size() - 1);
        data.stackTrace = StackTraceMap.getCallStackString(data.stackKey);
        sb.append(data).append("\n");
        sb.append("]");
        return sb.toString();
    }

    private void printProfilerOutput(String dataStream) {
        try (FileWriter myWriter = new FileWriter("cpu_pre.json", StandardCharsets.UTF_8);){
            myWriter.write(dataStream);
        }
        catch (IOException e) {
            throw new ProfilerRuntimeException("Error occurred while writing to the cpu_pre.json file");
        }
    }

    private void addProfilerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(Thread.ofVirtual().unstarted(() -> {
            ProfileAnalyzer profiler = ProfileAnalyzer.getInstance();
            profiler.printProfilerOutput(profiler.getProfileStackString());
        }));
    }

    private static class ProfilerHolder {
        private static final ProfileAnalyzer PROFILER_INSTANCE = new ProfileAnalyzer();

        private ProfilerHolder() {
        }
    }
}

