/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.ui;

import io.ballerina.runtime.profiler.runtime.ProfilerRuntimeException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FrontEnd {
    String getSiteData(String contents) {
        String htmlContent;
        try {
            htmlContent = this.readFileAsString();
        }
        catch (IOException e) {
            throw new ProfilerRuntimeException("error while reading profiler output.", e);
        }
        return htmlContent.replace("${profile_data}", contents);
    }

    public String readFileAsString() throws IOException {
        Path resourceFilePath = Path.of(System.getenv("ballerina.home"), new String[0]).resolve("resources").resolve("profiler").resolve("profiler_output.html");
        if (!Files.exists(resourceFilePath, new LinkOption[0])) {
            throw new ProfilerRuntimeException("resource file not found: profiler_output.html");
        }
        StringBuilder sb = new StringBuilder();
        try (FileInputStream inputStream = new FileInputStream(resourceFilePath.toFile());
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        return sb.toString();
    }
}

