/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.util;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.mime.util.EntityBodyChannel;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.EntityWrapper;
import io.ballerina.stdlib.mime.util.MimeConstants;
import io.ballerina.stdlib.mime.util.MimeEntityWrapper;
import io.ballerina.stdlib.mime.util.MimeUtil;
import io.ballerina.stdlib.mime.util.MultipartDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jvnet.mimepull.MIMEPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBodyHandler {
    private static final Logger log = LoggerFactory.getLogger(EntityBodyHandler.class);
    private static final Type MIME_ENTITY_TYPE = TypeUtils.getType((Object)ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"Entity", (Object[])new Object[0]));
    private static final ArrayType mimeEntityArrayType = TypeCreator.createArrayType((Type)MIME_ENTITY_TYPE);
    public static final String OUTPUT_STREAM = "output_stream_object";
    public static final String WRITE_EVENT_STREAM_METHOD = "writeEventStream";
    public static final String EVENT_STREAM_WRITER_OBJECT = "EventStreamWriter";

    public static EntityWrapper getEntityWrapper(String textPayload) {
        return new EntityWrapper(new EntityBodyChannel(new ByteArrayInputStream(textPayload.getBytes(StandardCharsets.UTF_8))));
    }

    public static Object getMessageDataSource(BObject entityObj) {
        return entityObj.getNativeData("message_datasource");
    }

    public static void addJsonMessageDataSource(BObject entityObj, Object messageDataSource) {
        EntityBodyHandler.setParseJsonAndDataSource(entityObj, messageDataSource, true);
    }

    public static void addMessageDataSource(BObject entityObj, Object messageDataSource) {
        EntityBodyHandler.setParseJsonAndDataSource(entityObj, messageDataSource, false);
    }

    private static void setParseJsonAndDataSource(BObject entityObj, Object messageDataSource, boolean json) {
        entityObj.addNativeData("PARSE_AS_TEXT", (Object)json);
        entityObj.addNativeData("message_datasource", messageDataSource);
    }

    public static BArray constructBlobDataSource(BObject entityObj) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            return ValueCreator.createArrayValue((byte[])new byte[0]);
        }
        try {
            BArray bArray = EntityBodyHandler.constructBlobDataSource(byteChannel.getInputStream());
            return bArray;
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static BArray constructBlobDataSource(InputStream inputStream) {
        byte[] byteData;
        try {
            byteData = MimeUtil.getByteArray(inputStream);
        }
        catch (IOException ex) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Error occurred while reading input stream :" + ex.getMessage())));
        }
        return ValueCreator.createArrayValue((byte[])byteData);
    }

    public static Object constructJsonDataSource(BObject entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            throw MimeUtil.createError("NoContentError", "empty JSON document");
        }
        try {
            Object object = EntityBodyHandler.constructJsonDataSource(entityObj, byteChannel.getInputStream());
            return object;
        }
        catch (IOException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static Object constructJsonDataSource(BObject entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = EntityHeaderHandler.getHeaderValue(entity, "content-type");
        Object jsonData = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? MimeUtil.parseAsJson(inputStream, charsetValue) : MimeUtil.parseAsJson(inputStream)) : MimeUtil.parseAsJson(inputStream);
        return jsonData;
    }

    public static BXml constructXmlDataSource(BObject entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            throw MimeUtil.createError("NoContentError", "Empty xml payload");
        }
        try {
            BXml bXml = EntityBodyHandler.constructXmlDataSource(entityObj, byteChannel.getInputStream());
            return bXml;
        }
        catch (IOException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static BXml constructXmlDataSource(BObject entityObj, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = EntityHeaderHandler.getHeaderValue(entityObj, "content-type");
        BXml xmlContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? MimeUtil.parseAsXml(inputStream, charsetValue) : MimeUtil.parseAsXml(inputStream)) : MimeUtil.parseAsXml(inputStream);
        return xmlContent;
    }

    public static BString constructStringDataSource(BObject entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            throw MimeUtil.createError("NoContentError", "String payload is null");
        }
        try {
            BString bString = EntityBodyHandler.constructStringDataSource(entityObj, byteChannel.getInputStream());
            return bString;
        }
        catch (IOException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
        }
        finally {
            EntityBodyHandler.closeByteChannel(byteChannel);
        }
    }

    public static BString constructStringDataSource(BObject entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = EntityHeaderHandler.getHeaderValue(entity, "content-type");
        BString textContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? StringUtils.getStringFromInputStream((InputStream)inputStream, (String)charsetValue) : StringUtils.getStringFromInputStream((InputStream)inputStream)) : StringUtils.getStringFromInputStream((InputStream)inputStream);
        return textContent;
    }

    public static boolean checkEntityBodyAvailability(BObject entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null || EntityBodyHandler.getMessageDataSource(entityObj) != null || entityObj.getNativeData("body_parts") != null || entityObj.getNativeData("entity_byte_stream") != null;
    }

    public static boolean isStreamingRequired(BObject entity) {
        return entity.getNativeData("entity_byte_channel") != null || entity.getNativeData("body_parts") != null;
    }

    static void setPartsToTopLevelEntity(BObject entity, ArrayList<BObject> bodyParts) {
        if (!bodyParts.isEmpty()) {
            ObjectType typeOfBodyPart = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)bodyParts.get(0)));
            Object[] result = bodyParts.toArray(new BObject[bodyParts.size()]);
            BArray partsArray = ValueCreator.createArrayValue((Object[])result, (ArrayType)TypeCreator.createArrayType((Type)typeOfBodyPart));
            entity.addNativeData("body_parts", (Object)partsArray);
        }
    }

    public static void populateBodyContent(BObject bodyPart, MIMEPart mimePart) {
        bodyPart.addNativeData("entity_byte_channel", (Object)new MimeEntityWrapper(new EntityBodyChannel(mimePart.readOnce()), mimePart));
    }

    public static void writeByteChannelToOutputStream(BObject entityObj, OutputStream messageOutputStream) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel != null) {
            MimeUtil.writeInputToOutputStream(byteChannel.getInputStream(), messageOutputStream);
            byteChannel.close();
            entityObj.addNativeData("entity_byte_channel", null);
        }
    }

    public static void writeByteStreamToOutputStream(Environment env, BObject entity, OutputStream outputStream) {
        BStream byteStream = EntityBodyHandler.getByteStream(entity);
        if (byteStream != null) {
            BObject iteratorObj = byteStream.getIteratorObj();
            EntityBodyHandler.writeContent(env, entity, outputStream, iteratorObj);
        }
    }

    private static void writeContent(Environment env, BObject entity, OutputStream outputStream, BObject iteratorObj) {
        try {
            Object result = env.getRuntime().callMethod(iteratorObj, "next", null, new Object[0]);
            EntityBodyHandler.handleContentResult(env, entity, outputStream, result, iteratorObj);
        }
        catch (BError error) {
            EntityBodyHandler.handleContentPanic(error);
        }
        catch (Throwable throwable) {
            EntityBodyHandler.handleContentPanic(ErrorCreator.createError((Throwable)throwable));
        }
    }

    public static void handleContentResult(Environment env, BObject entity, OutputStream outputStream, Object result, BObject iteratorObj) {
        if (result == null) {
            entity.addNativeData("entity_byte_stream", null);
            return;
        }
        if (result instanceof BError) {
            BError error = (BError)((Object)result);
            entity.addNativeData("entity_byte_stream", null);
            EntityBodyHandler.handleContentPanic(error);
        }
        try {
            EntityBodyHandler.writeContentPart((BMap)result, outputStream);
        }
        catch (Exception e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Error occurred while writing the stream content: " + MimeUtil.removeJavaExceptionPrefix(e.getMessage()))));
        }
        EntityBodyHandler.writeContent(env, entity, outputStream, iteratorObj);
    }

    public static void handleContentPanic(BError bError) {
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Error occurred while streaming content: " + bError.getMessage())));
    }

    public static void writeEventStreamToOutputStream(Environment env, BObject entity, OutputStream outputStream) {
        BStream eventByteStream = EntityBodyHandler.getEventStream(entity);
        if (eventByteStream != null) {
            BObject eventStreamWriter = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)EVENT_STREAM_WRITER_OBJECT, (Object[])new Object[]{eventByteStream});
            eventStreamWriter.addNativeData("Entity", (Object)entity);
            eventStreamWriter.addNativeData(OUTPUT_STREAM, (Object)outputStream);
            EntityBodyHandler.writeEvent(env, eventStreamWriter);
        }
    }

    private static void writeEvent(Environment env, BObject eventStreamWriter) {
        try {
            EntityBodyHandler.handleEventResult(eventStreamWriter, env.getRuntime().callMethod(eventStreamWriter, WRITE_EVENT_STREAM_METHOD, null, new Object[0]));
        }
        catch (BError error) {
            EntityBodyHandler.handleEventPanic(eventStreamWriter, error);
        }
        catch (Throwable throwable) {
            EntityBodyHandler.handleEventPanic(eventStreamWriter, ErrorCreator.createError((Throwable)throwable));
        }
    }

    public static void handleEventResult(BObject eventStreamWriter, Object result) {
        BObject entity = (BObject)eventStreamWriter.getNativeData("Entity");
        OutputStream outputStream = (OutputStream)eventStreamWriter.getNativeData(OUTPUT_STREAM);
        if (result == null) {
            entity.addNativeData("entity_byte_stream", null);
            EntityBodyHandler.closeMessageOutputStream(outputStream);
            return;
        }
        if (result instanceof BError) {
            BError error = (BError)((Object)result);
            entity.addNativeData("entity_byte_stream", null);
            throw error;
        }
    }

    private static void handleEventPanic(BObject eventStreamWriter, BError bError) {
        OutputStream outputStream = (OutputStream)eventStreamWriter.getNativeData(OUTPUT_STREAM);
        EntityBodyHandler.closeMessageOutputStream(outputStream);
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Error occurred while streaming content: " + bError.getMessage())));
    }

    private static void closeMessageOutputStream(OutputStream messageOutputStream) {
        try {
            if (messageOutputStream != null) {
                messageOutputStream.close();
            }
        }
        catch (Exception e) {
            log.error("Couldn't close message output stream", (Throwable)e);
        }
    }

    private static void writeContentPart(BMap part, OutputStream outputStream) {
        BArray arrayValue = part.getArrayValue(MimeConstants.FIELD_VALUE);
        EntityBodyHandler.writeContentPart(arrayValue.getBytes(), outputStream);
    }

    private static void writeContentPart(byte[] bytes, OutputStream outputStream) {
        try (ByteArrayInputStream str = new ByteArrayInputStream(bytes);){
            MimeUtil.writeInputToOutputStream(str, outputStream);
        }
        catch (IOException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("Error occurred while writing content parts to output stream: " + e.getMessage())));
        }
    }

    public static Object writeEventStreamBytesToOutputStream(BObject eventStreamWriter, byte[] bytes) {
        OutputStream outputStream = (OutputStream)eventStreamWriter.getNativeData(OUTPUT_STREAM);
        try {
            EntityBodyHandler.writeContentPart(bytes, outputStream);
        }
        catch (Exception e) {
            return ErrorCreator.createError((BString)StringUtils.fromString((String)MimeUtil.removeJavaExceptionPrefix(e.getMessage())));
        }
        return null;
    }

    public static void decodeEntityBody(BObject entityObj, Channel byteChannel) throws IOException {
        String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
        if (!MimeUtil.isNotNullAndEmpty(contentType) || !contentType.startsWith("multipart/")) {
            return;
        }
        try {
            MultipartDecoder.parseBody(entityObj, contentType, byteChannel.getInputStream());
        }
        catch (IOException e) {
            throw new IOException("Unable to get a byte channel input stream to decode entity body", e);
        }
    }

    public static BArray getBodyPartArray(BObject entityObj) {
        return entityObj.getNativeData("body_parts") != null ? (BArray)entityObj.getNativeData("body_parts") : ValueCreator.createArrayValue((ArrayType)mimeEntityArrayType, (int)0);
    }

    public static Channel getByteChannel(BObject entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null ? (Channel)entityObj.getNativeData("entity_byte_channel") : null;
    }

    public static BStream getByteStream(BObject entityObj) {
        return entityObj.getNativeData("entity_byte_stream") != null ? (BStream)entityObj.getNativeData("entity_byte_stream") : null;
    }

    public static BStream getEventStream(BObject entityObj) {
        String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
        return contentType.startsWith("text/event-stream") ? EntityBodyHandler.getByteStream(entityObj) : null;
    }

    public static void closeByteChannel(Channel byteChannel) {
        try {
            byteChannel.close();
        }
        catch (IOException e) {
            log.error("Error occurred while closing byte channel", (Throwable)e);
        }
    }

    private EntityBodyHandler() {
    }
}

