/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.openapi.validator.NodeValidator;
import io.ballerina.openapi.validator.TypeValidatorUtils;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ParameterValidator
extends NodeValidator {
    private final Map<String, Node> parameters;
    private final List<Parameter> oasParameters;

    public ParameterValidator(ValidatorContext validatorContext, Map<String, Node> parameters, List<Parameter> oasParameters) {
        super(validatorContext);
        this.parameters = parameters;
        this.oasParameters = oasParameters;
    }

    @Override
    public void validateOpenAPIToBallerina() {
        if (this.oasParameters == null) {
            return;
        }
        this.oasParameters.forEach(parameter -> {
            if (parameter.get$ref() != null) {
                Optional<String> parameterName = ValidatorUtils.extractReferenceType(parameter.get$ref());
                if (parameterName.isEmpty()) {
                    return;
                }
                parameter = this.validatorContext.getOpenAPI().getComponents().getParameters().get(parameterName.get());
            }
            if (!(parameter instanceof HeaderParameter) || parameter.getIn() != null && !parameter.getIn().equals("header")) {
                boolean isImplemented = false;
                for (Map.Entry<String, Node> param : this.parameters.entrySet()) {
                    if (!parameter.getName().equals(param.getKey())) continue;
                    isImplemented = true;
                }
                if (!isImplemented) {
                    ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.MISSING_PARAMETER, parameter.getName(), this.validatorContext.getMethod(), this.validatorContext.getPath());
                }
            }
        });
    }

    @Override
    public void validateBallerinaToOpenAPI() {
        for (Map.Entry<String, Node> parameter : this.parameters.entrySet()) {
            String ballerinaType;
            boolean isExist = false;
            String parameterName = ValidatorUtils.unescapeIdentifier(parameter.getKey());
            if (parameter.getValue() instanceof ParameterNode) {
                ParameterNode paramNode = (ParameterNode)parameter.getValue();
                if (paramNode instanceof RequiredParameterNode) {
                    RequiredParameterNode requireParam = (RequiredParameterNode)paramNode;
                    ballerinaType = requireParam.typeName().toString().trim().replaceAll("\\?", "");
                } else {
                    DefaultableParameterNode defaultParam = (DefaultableParameterNode)paramNode;
                    ballerinaType = defaultParam.typeName().toString().trim().replaceAll("\\?", "");
                }
            } else {
                ResourcePathParameterNode pathParameterNode = (ResourcePathParameterNode)parameter.getValue();
                ballerinaType = TypeValidatorUtils.convertBallerinaType(pathParameterNode.typeDescriptor().kind()).orElse(null);
            }
            if (this.oasParameters != null) {
                for (Parameter oasParameter : this.oasParameters) {
                    String oasParameterName = oasParameter.getName();
                    Schema schema = oasParameter.getSchema();
                    if (oasParameter.get$ref() != null) {
                        Optional<String> name = ValidatorUtils.extractReferenceType(oasParameter.get$ref());
                        if (name.isEmpty()) {
                            return;
                        }
                        oasParameterName = name.get();
                        Components components = this.validatorContext.getOpenAPI().getComponents();
                        schema = components.getParameters().get(oasParameterName).getSchema();
                        if (components.getParameters().get(oasParameterName).getName() != null) {
                            oasParameterName = components.getParameters().get(oasParameterName).getName();
                        }
                    }
                    if (!parameterName.equals(oasParameterName)) continue;
                    isExist = true;
                    String oasType = ValidatorUtils.getNumberFormatType(schema);
                    if (oasType.equals("array") && schema instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)schema;
                        oasType = arraySchema.getItems().getType();
                    }
                    Optional<String> type = TypeValidatorUtils.convertOpenAPITypeToBallerina(oasType);
                    SyntaxNodeAnalysisContext context = this.validatorContext.getContext();
                    DiagnosticSeverity severity = this.validatorContext.getSeverity();
                    String method = this.validatorContext.getMethod();
                    String path = this.validatorContext.getPath();
                    if (type.isEmpty() || Objects.requireNonNull(ballerinaType).contains("[]") && !ballerinaType.equals(type.get() + "[]")) {
                        ValidatorUtils.reportDiagnostic(context, CompilationError.TYPE_MISMATCH_PARAMETER, (Location)parameter.getValue().location(), severity, oasType + "[]", ballerinaType, parameterName, method, path);
                        break;
                    }
                    if (Objects.equals(ballerinaType, type.get())) continue;
                    ValidatorUtils.reportDiagnostic(context, CompilationError.TYPE_MISMATCH_PARAMETER, (Location)parameter.getValue().location(), severity, oasType, ballerinaType, parameterName, method, path);
                    break;
                }
            }
            if (isExist) continue;
            ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.UNDEFINED_PARAMETER, (Location)parameter.getValue().location(), this.validatorContext.getSeverity(), parameterName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
        }
    }
}

