/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.incremental;

import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.BallerinaParser;
import io.ballerina.compiler.internal.parser.incremental.UnmodifiedSubtreeSupplier;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.function.Predicate;

public class IncrementalParser
extends BallerinaParser {
    private final UnmodifiedSubtreeSupplier subtreeSupplier;
    private final Predicate<SyntaxKind> isModelLevelDeclaration = kind -> SyntaxKind.IMPORT_DECLARATION.compareTo(kind) <= 0 && SyntaxKind.ENUM_DECLARATION.compareTo(kind) >= 0;
    private final Predicate<SyntaxKind> isFunctionBody = kind -> kind == SyntaxKind.FUNCTION_BODY_BLOCK || kind == SyntaxKind.EXTERNAL_FUNCTION_BODY || kind == SyntaxKind.EXPRESSION_FUNCTION_BODY;
    private final Predicate<SyntaxKind> isStatement = kind -> SyntaxKind.BLOCK_STATEMENT.compareTo(kind) <= 0 && SyntaxKind.INVALID_EXPRESSION_STATEMENT.compareTo(kind) >= 0;

    public IncrementalParser(AbstractTokenReader tokenReader, UnmodifiedSubtreeSupplier subtreeSupplier) {
        super(tokenReader);
        this.subtreeSupplier = subtreeSupplier;
    }

    @Override
    protected STNode parseTopLevelNode() {
        STNode modelLevelDecl = this.getIfReusable(this.subtreeSupplier.peek(), this.isModelLevelDeclaration);
        return modelLevelDecl != null ? modelLevelDecl : super.parseTopLevelNode();
    }

    @Override
    protected STNode parseFunctionBody() {
        STNode funcBodyNode = this.getIfReusable(this.subtreeSupplier.peek(), this.isFunctionBody);
        return funcBodyNode != null ? funcBodyNode : super.parseFunctionBody();
    }

    @Override
    protected STNode parseStatement() {
        STNode stmtNode = this.getIfReusable(this.subtreeSupplier.peek(), this.isStatement);
        return stmtNode != null ? stmtNode : super.parseStatement();
    }

    private STNode getIfReusable(STNode node, Predicate<SyntaxKind> predicate) {
        if (node != null && predicate.test(node.kind)) {
            this.subtreeSupplier.consume();
        }
        return node;
    }
}

