/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STArrayDimensionNode
extends STNode {
    public final STNode openBracket;
    public final STNode arrayLength;
    public final STNode closeBracket;

    STArrayDimensionNode(STNode openBracket, STNode arrayLength, STNode closeBracket) {
        this(openBracket, arrayLength, closeBracket, Collections.emptyList());
    }

    STArrayDimensionNode(STNode openBracket, STNode arrayLength, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ARRAY_DIMENSION, diagnostics);
        this.openBracket = openBracket;
        this.arrayLength = arrayLength;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, arrayLength, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STArrayDimensionNode(this.openBracket, this.arrayLength, this.closeBracket, diagnostics);
    }

    public STArrayDimensionNode modify(STNode openBracket, STNode arrayLength, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, arrayLength, closeBracket)) {
            return this;
        }
        return new STArrayDimensionNode(openBracket, arrayLength, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ArrayDimensionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

