/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.DoubleGTTokenNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDoubleGTTokenNode
extends STNode {
    public final STNode openGTToken;
    public final STNode endGTToken;

    STDoubleGTTokenNode(STNode openGTToken, STNode endGTToken) {
        this(openGTToken, endGTToken, Collections.emptyList());
    }

    STDoubleGTTokenNode(STNode openGTToken, STNode endGTToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.DOUBLE_GT_TOKEN, diagnostics);
        this.openGTToken = openGTToken;
        this.endGTToken = endGTToken;
        this.addChildren(openGTToken, endGTToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDoubleGTTokenNode(this.openGTToken, this.endGTToken, diagnostics);
    }

    public STDoubleGTTokenNode modify(STNode openGTToken, STNode endGTToken) {
        if (this.checkForReferenceEquality(openGTToken, endGTToken)) {
            return this;
        }
        return new STDoubleGTTokenNode(openGTToken, endGTToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DoubleGTTokenNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

