/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLItemNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STInterpolationNode
extends STXMLItemNode {
    public final STNode interpolationStartToken;
    public final STNode expression;
    public final STNode interpolationEndToken;

    STInterpolationNode(STNode interpolationStartToken, STNode expression, STNode interpolationEndToken) {
        this(interpolationStartToken, expression, interpolationEndToken, Collections.emptyList());
    }

    STInterpolationNode(STNode interpolationStartToken, STNode expression, STNode interpolationEndToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INTERPOLATION, diagnostics);
        this.interpolationStartToken = interpolationStartToken;
        this.expression = expression;
        this.interpolationEndToken = interpolationEndToken;
        this.addChildren(interpolationStartToken, expression, interpolationEndToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STInterpolationNode(this.interpolationStartToken, this.expression, this.interpolationEndToken, diagnostics);
    }

    public STInterpolationNode modify(STNode interpolationStartToken, STNode expression, STNode interpolationEndToken) {
        if (this.checkForReferenceEquality(interpolationStartToken, expression, interpolationEndToken)) {
            return this;
        }
        return new STInterpolationNode(interpolationStartToken, expression, interpolationEndToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new InterpolationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

