/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.LetClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STLetClauseNode
extends STIntermediateClauseNode {
    public final STNode letKeyword;
    public final STNode letVarDeclarations;

    STLetClauseNode(STNode letKeyword, STNode letVarDeclarations) {
        this(letKeyword, letVarDeclarations, Collections.emptyList());
    }

    STLetClauseNode(STNode letKeyword, STNode letVarDeclarations, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LET_CLAUSE, diagnostics);
        this.letKeyword = letKeyword;
        this.letVarDeclarations = letVarDeclarations;
        this.addChildren(letKeyword, letVarDeclarations);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STLetClauseNode(this.letKeyword, this.letVarDeclarations, diagnostics);
    }

    public STLetClauseNode modify(STNode letKeyword, STNode letVarDeclarations) {
        if (this.checkForReferenceEquality(letKeyword, letVarDeclarations)) {
            return this;
        }
        return new STLetClauseNode(letKeyword, letVarDeclarations, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new LetClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

