/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MarkdownCodeBlockNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMarkdownCodeBlockNode
extends STDocumentationNode {
    public final STNode startLineHashToken;
    public final STNode startBacktick;
    public final STNode langAttribute;
    public final STNode codeLines;
    public final STNode endLineHashToken;
    public final STNode endBacktick;

    STMarkdownCodeBlockNode(STNode startLineHashToken, STNode startBacktick, STNode langAttribute, STNode codeLines, STNode endLineHashToken, STNode endBacktick) {
        this(startLineHashToken, startBacktick, langAttribute, codeLines, endLineHashToken, endBacktick, Collections.emptyList());
    }

    STMarkdownCodeBlockNode(STNode startLineHashToken, STNode startBacktick, STNode langAttribute, STNode codeLines, STNode endLineHashToken, STNode endBacktick, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MARKDOWN_CODE_BLOCK, diagnostics);
        this.startLineHashToken = startLineHashToken;
        this.startBacktick = startBacktick;
        this.langAttribute = langAttribute;
        this.codeLines = codeLines;
        this.endLineHashToken = endLineHashToken;
        this.endBacktick = endBacktick;
        this.addChildren(startLineHashToken, startBacktick, langAttribute, codeLines, endLineHashToken, endBacktick);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMarkdownCodeBlockNode(this.startLineHashToken, this.startBacktick, this.langAttribute, this.codeLines, this.endLineHashToken, this.endBacktick, diagnostics);
    }

    public STMarkdownCodeBlockNode modify(STNode startLineHashToken, STNode startBacktick, STNode langAttribute, STNode codeLines, STNode endLineHashToken, STNode endBacktick) {
        if (this.checkForReferenceEquality(startLineHashToken, startBacktick, langAttribute, codeLines, endLineHashToken, endBacktick)) {
            return this;
        }
        return new STMarkdownCodeBlockNode(startLineHashToken, startBacktick, langAttribute, codeLines, endLineHashToken, endBacktick, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MarkdownCodeBlockNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

