/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NamedArgMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNamedArgMatchPatternNode
extends STNode {
    public final STNode identifier;
    public final STNode equalToken;
    public final STNode matchPattern;

    STNamedArgMatchPatternNode(STNode identifier, STNode equalToken, STNode matchPattern) {
        this(identifier, equalToken, matchPattern, Collections.emptyList());
    }

    STNamedArgMatchPatternNode(STNode identifier, STNode equalToken, STNode matchPattern, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NAMED_ARG_MATCH_PATTERN, diagnostics);
        this.identifier = identifier;
        this.equalToken = equalToken;
        this.matchPattern = matchPattern;
        this.addChildren(identifier, equalToken, matchPattern);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNamedArgMatchPatternNode(this.identifier, this.equalToken, this.matchPattern, diagnostics);
    }

    public STNamedArgMatchPatternNode modify(STNode identifier, STNode equalToken, STNode matchPattern) {
        if (this.checkForReferenceEquality(identifier, equalToken, matchPattern)) {
            return this;
        }
        return new STNamedArgMatchPatternNode(identifier, equalToken, matchPattern, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NamedArgMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

