/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STFunctionArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STPositionalArgumentNode
extends STFunctionArgumentNode {
    public final STNode expression;

    STPositionalArgumentNode(STNode expression) {
        this(expression, Collections.emptyList());
    }

    STPositionalArgumentNode(STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.POSITIONAL_ARG, diagnostics);
        this.expression = expression;
        this.addChildren(expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STPositionalArgumentNode(this.expression, diagnostics);
    }

    public STPositionalArgumentNode modify(STNode expression) {
        if (this.checkForReferenceEquality(expression)) {
            return this;
        }
        return new STPositionalArgumentNode(expression, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new PositionalArgumentNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

