/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STReTermNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReAtomQuantifierNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReAtomQuantifierNode
extends STReTermNode {
    public final STNode reAtom;
    public final STNode reQuantifier;

    STReAtomQuantifierNode(STNode reAtom, STNode reQuantifier) {
        this(reAtom, reQuantifier, Collections.emptyList());
    }

    STReAtomQuantifierNode(STNode reAtom, STNode reQuantifier, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_ATOM_QUANTIFIER, diagnostics);
        this.reAtom = reAtom;
        this.reQuantifier = reQuantifier;
        this.addChildren(reAtom, reQuantifier);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReAtomQuantifierNode(this.reAtom, this.reQuantifier, diagnostics);
    }

    public STReAtomQuantifierNode modify(STNode reAtom, STNode reQuantifier) {
        if (this.checkForReferenceEquality(reAtom, reQuantifier)) {
            return this;
        }
        return new STReAtomQuantifierNode(reAtom, reQuantifier, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReAtomQuantifierNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

