/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STSelectClauseNode
extends STClauseNode {
    public final STNode selectKeyword;
    public final STNode expression;

    STSelectClauseNode(STNode selectKeyword, STNode expression) {
        this(selectKeyword, expression, Collections.emptyList());
    }

    STSelectClauseNode(STNode selectKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SELECT_CLAUSE, diagnostics);
        this.selectKeyword = selectKeyword;
        this.expression = expression;
        this.addChildren(selectKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STSelectClauseNode(this.selectKeyword, this.expression, diagnostics);
    }

    public STSelectClauseNode modify(STNode selectKeyword, STNode expression) {
        if (this.checkForReferenceEquality(selectKeyword, expression)) {
            return this;
        }
        return new STSelectClauseNode(selectKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new SelectClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

