/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STMappingFieldNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STSpecificFieldNode
extends STMappingFieldNode {
    public final STNode readonlyKeyword;
    public final STNode fieldName;
    public final STNode colon;
    public final STNode valueExpr;

    STSpecificFieldNode(STNode readonlyKeyword, STNode fieldName, STNode colon, STNode valueExpr) {
        this(readonlyKeyword, fieldName, colon, valueExpr, Collections.emptyList());
    }

    STSpecificFieldNode(STNode readonlyKeyword, STNode fieldName, STNode colon, STNode valueExpr, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SPECIFIC_FIELD, diagnostics);
        this.readonlyKeyword = readonlyKeyword;
        this.fieldName = fieldName;
        this.colon = colon;
        this.valueExpr = valueExpr;
        this.addChildren(readonlyKeyword, fieldName, colon, valueExpr);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STSpecificFieldNode(this.readonlyKeyword, this.fieldName, this.colon, this.valueExpr, diagnostics);
    }

    public STSpecificFieldNode modify(STNode readonlyKeyword, STNode fieldName, STNode colon, STNode valueExpr) {
        if (this.checkForReferenceEquality(readonlyKeyword, fieldName, colon, valueExpr)) {
            return this;
        }
        return new STSpecificFieldNode(readonlyKeyword, fieldName, colon, valueExpr, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new SpecificFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

