/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeCastParamNode
extends STNode {
    public final STNode annotations;
    public final STNode type;

    STTypeCastParamNode(STNode annotations, STNode type) {
        this(annotations, type, Collections.emptyList());
    }

    STTypeCastParamNode(STNode annotations, STNode type, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_CAST_PARAM, diagnostics);
        this.annotations = annotations;
        this.type = type;
        this.addChildren(annotations, type);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeCastParamNode(this.annotations, this.type, diagnostics);
    }

    public STTypeCastParamNode modify(STNode annotations, STNode type) {
        if (this.checkForReferenceEquality(annotations, type)) {
            return this;
        }
        return new STTypeCastParamNode(annotations, type, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeCastParamNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

