/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeReferenceTypeDescNode
extends STTypeDescriptorNode {
    public final STNode typeRef;

    STTypeReferenceTypeDescNode(STNode typeRef) {
        this(typeRef, Collections.emptyList());
    }

    STTypeReferenceTypeDescNode(STNode typeRef, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_REFERENCE_TYPE_DESC, diagnostics);
        this.typeRef = typeRef;
        this.addChildren(typeRef);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeReferenceTypeDescNode(this.typeRef, diagnostics);
    }

    public STTypeReferenceTypeDescNode modify(STNode typeRef) {
        if (this.checkForReferenceEquality(typeRef)) {
            return this;
        }
        return new STTypeReferenceTypeDescNode(typeRef, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeReferenceTypeDescNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

