/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WhereClauseNode;
import java.util.Collection;
import java.util.Collections;

public class STWhereClauseNode
extends STIntermediateClauseNode {
    public final STNode whereKeyword;
    public final STNode expression;

    STWhereClauseNode(STNode whereKeyword, STNode expression) {
        this(whereKeyword, expression, Collections.emptyList());
    }

    STWhereClauseNode(STNode whereKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.WHERE_CLAUSE, diagnostics);
        this.whereKeyword = whereKeyword;
        this.expression = expression;
        this.addChildren(whereKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STWhereClauseNode(this.whereKeyword, this.expression, diagnostics);
    }

    public STWhereClauseNode modify(STNode whereKeyword, STNode expression) {
        if (this.checkForReferenceEquality(whereKeyword, expression)) {
            return this;
        }
        return new STWhereClauseNode(whereKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new WhereClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

