/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLAttributeValue;
import java.util.Collection;
import java.util.Collections;

public class STXMLAttributeValue
extends STNode {
    public final STNode startQuote;
    public final STNode value;
    public final STNode endQuote;

    STXMLAttributeValue(STNode startQuote, STNode value, STNode endQuote) {
        this(startQuote, value, endQuote, Collections.emptyList());
    }

    STXMLAttributeValue(STNode startQuote, STNode value, STNode endQuote, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_ATTRIBUTE_VALUE, diagnostics);
        this.startQuote = startQuote;
        this.value = value;
        this.endQuote = endQuote;
        this.addChildren(startQuote, value, endQuote);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLAttributeValue(this.startQuote, this.value, this.endQuote, diagnostics);
    }

    public STXMLAttributeValue modify(STNode startQuote, STNode value, STNode endQuote) {
        if (this.checkForReferenceEquality(startQuote, value, endQuote)) {
            return this;
        }
        return new STXMLAttributeValue(startQuote, value, endQuote, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLAttributeValue(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

