/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class FieldBindingPatternFullNode
extends FieldBindingPatternNode {
    public FieldBindingPatternFullNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SimpleNameReferenceNode variableName() {
        return (SimpleNameReferenceNode)this.childInBucket(0);
    }

    public Token colon() {
        return (Token)this.childInBucket(1);
    }

    public BindingPatternNode bindingPattern() {
        return (BindingPatternNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"variableName", "colon", "bindingPattern"};
    }

    public FieldBindingPatternFullNode modify(SimpleNameReferenceNode variableName, Token colon, BindingPatternNode bindingPattern) {
        if (this.checkForReferenceEquality(variableName, colon, bindingPattern)) {
            return this;
        }
        return NodeFactory.createFieldBindingPatternFullNode(variableName, colon, bindingPattern);
    }

    public FieldBindingPatternFullNodeModifier modify() {
        return new FieldBindingPatternFullNodeModifier(this);
    }

    public static class FieldBindingPatternFullNodeModifier {
        private final FieldBindingPatternFullNode oldNode;
        private SimpleNameReferenceNode variableName;
        private Token colon;
        private BindingPatternNode bindingPattern;

        public FieldBindingPatternFullNodeModifier(FieldBindingPatternFullNode oldNode) {
            this.oldNode = oldNode;
            this.variableName = oldNode.variableName();
            this.colon = oldNode.colon();
            this.bindingPattern = oldNode.bindingPattern();
        }

        public FieldBindingPatternFullNodeModifier withVariableName(SimpleNameReferenceNode variableName) {
            Objects.requireNonNull(variableName, "variableName must not be null");
            this.variableName = variableName;
            return this;
        }

        public FieldBindingPatternFullNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public FieldBindingPatternFullNodeModifier withBindingPattern(BindingPatternNode bindingPattern) {
            Objects.requireNonNull(bindingPattern, "bindingPattern must not be null");
            this.bindingPattern = bindingPattern;
            return this;
        }

        public FieldBindingPatternFullNode apply() {
            return this.oldNode.modify(this.variableName, this.colon, this.bindingPattern);
        }
    }
}

