/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class IncludedRecordParameterNode
extends ParameterNode {
    public IncludedRecordParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Token asteriskToken() {
        return (Token)this.childInBucket(1);
    }

    public Node typeName() {
        return this.childInBucket(2);
    }

    public Optional<Token> paramName() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "asteriskToken", "typeName", "paramName"};
    }

    public IncludedRecordParameterNode modify(NodeList<AnnotationNode> annotations, Token asteriskToken, Node typeName, Token paramName) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), asteriskToken, typeName, paramName)) {
            return this;
        }
        return NodeFactory.createIncludedRecordParameterNode(annotations, asteriskToken, typeName, paramName);
    }

    public IncludedRecordParameterNodeModifier modify() {
        return new IncludedRecordParameterNodeModifier(this);
    }

    public static class IncludedRecordParameterNodeModifier {
        private final IncludedRecordParameterNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token asteriskToken;
        private Node typeName;
        private Token paramName;

        public IncludedRecordParameterNodeModifier(IncludedRecordParameterNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.asteriskToken = oldNode.asteriskToken();
            this.typeName = oldNode.typeName();
            this.paramName = oldNode.paramName().orElse(null);
        }

        public IncludedRecordParameterNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public IncludedRecordParameterNodeModifier withAsteriskToken(Token asteriskToken) {
            Objects.requireNonNull(asteriskToken, "asteriskToken must not be null");
            this.asteriskToken = asteriskToken;
            return this;
        }

        public IncludedRecordParameterNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public IncludedRecordParameterNodeModifier withParamName(Token paramName) {
            this.paramName = paramName;
            return this;
        }

        public IncludedRecordParameterNode apply() {
            return this.oldNode.modify(this.annotations, this.asteriskToken, this.typeName, this.paramName);
        }
    }
}

