/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.syntax.tree.CommentNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NodeAndCommentList<T extends Node>
implements Iterable<T> {
    protected final STNodeList internalListNode;
    protected final NonTerminalNode nonTerminalNode;
    protected final int size;
    protected final Node[] nodes;

    NodeAndCommentList(NonTerminalNode nonTerminalNode, Token semicolon) {
        this(nonTerminalNode, semicolon, nonTerminalNode.bucketCount() * 2 + 1);
    }

    protected NodeAndCommentList(NonTerminalNode nonTerminalNode, Token semicolon, int size) {
        if (!NodeListUtils.isSTNodeList(nonTerminalNode.internalNode())) {
            throw new IllegalArgumentException("An STNodeList instance is expected");
        }
        this.internalListNode = (STNodeList)nonTerminalNode.internalNode();
        this.nonTerminalNode = nonTerminalNode;
        this.nodes = new Node[size];
        int nodeIndex = 0;
        for (int i = 0; i < nonTerminalNode.bucketCount(); ++i) {
            Object node = nonTerminalNode.childInBucket(i);
            CommentNode commentNode = this.getCommentNode((Node)node);
            if (commentNode != null) {
                this.nodes[nodeIndex++] = commentNode;
            }
            this.nodes[nodeIndex++] = node;
        }
        CommentNode commentNodeBeforeEnd = this.getCommentNode(semicolon);
        if (commentNodeBeforeEnd != null) {
            this.nodes[nodeIndex++] = commentNodeBeforeEnd;
        }
        this.size = nodeIndex;
    }

    private CommentNode getCommentNode(Node node) {
        ArrayList<String> commentLines = new ArrayList<String>();
        Minutiae lastMinutiae = null;
        for (Minutiae minutiae : node.leadingMinutiae()) {
            String[] splits = minutiae.text().split("// ");
            if (splits.length >= 2) {
                commentLines.add(splits[1]);
                lastMinutiae = minutiae;
                continue;
            }
            if (splits.length != 1 || !splits[0].contains("//")) continue;
            commentLines.add("");
            lastMinutiae = minutiae;
        }
        if (commentLines.isEmpty()) {
            return null;
        }
        CommentNode commentNode = new CommentNode(node.internalNode(), 0, null);
        commentNode.setCommentAttachedNode(node);
        commentNode.setLastMinutiae(lastMinutiae);
        commentNode.setCommentLines(commentLines);
        return commentNode;
    }

    public T get(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return (T)this.nodes[index];
    }

    public NodeAndCommentList<T> add(T node) {
        Objects.requireNonNull(node, "node should not be null");
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.add(((Node)node).internalNode()).createUnlinkedFacade(), null);
    }

    public NodeAndCommentList<T> add(int index, T node) {
        Objects.requireNonNull(node, "node should not be null");
        NodeListUtils.rangeCheckForAdd(index, this.size);
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.add(index, ((Node)node).internalNode()).createUnlinkedFacade(), null);
    }

    public NodeAndCommentList<T> addAll(Collection<T> c) {
        if (c.isEmpty()) {
            return this;
        }
        List<STNode> stNodesToBeAdded = c.stream().map(node -> Objects.requireNonNull(node, "node should not be null")).map(Node::internalNode).collect(Collectors.toList());
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.addAll(stNodesToBeAdded).createUnlinkedFacade(), null);
    }

    public NodeAndCommentList<T> set(int index, T node) {
        Objects.requireNonNull(node, "node should not be null");
        NodeListUtils.rangeCheck(index, this.size);
        if (this.nonTerminalNode.checkForReferenceEquality(index, (Node)node)) {
            return this;
        }
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.set(index, ((Node)node).internalNode()).createUnlinkedFacade(), null);
    }

    public NodeAndCommentList<T> remove(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.remove(index).createUnlinkedFacade(), null);
    }

    public NodeAndCommentList<T> remove(T node) {
        Objects.requireNonNull(node, "node should not be null");
        for (int bucket = 0; bucket < this.nonTerminalNode.bucketCount(); ++bucket) {
            if (!this.nonTerminalNode.checkForReferenceEquality(bucket, (Node)node)) continue;
            return this.remove((T)bucket);
        }
        return this;
    }

    public NodeAndCommentList<T> removeAll(Collection<T> c) {
        if (c.isEmpty()) {
            return this;
        }
        c.forEach(node -> Objects.requireNonNull(node, "node should not be null"));
        ArrayList<STNode> toBeDeletedList = new ArrayList<STNode>();
        for (int bucket = 0; bucket < this.nonTerminalNode.bucketCount(); ++bucket) {
            Node childNode = this.nonTerminalNode.childBuckets[bucket];
            if (!c.contains(childNode)) continue;
            toBeDeletedList.add(childNode.internalNode());
        }
        return new NodeAndCommentList<T>((NonTerminalNode)this.internalListNode.removeAll(toBeDeletedList).createUnlinkedFacade(), null);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeAndCommentListIterator();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    NonTerminalNode underlyingListNode() {
        return this.nonTerminalNode;
    }

    protected class NodeAndCommentListIterator
    implements Iterator<T> {
        private int currentIndex = 0;

        protected NodeAndCommentListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < NodeAndCommentList.this.size;
        }

        @Override
        public T next() {
            return NodeAndCommentList.this.get(this.currentIndex++);
        }
    }
}

