/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ObjectConstructorExpressionNode
extends ExpressionNode {
    public ObjectConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public NodeList<Token> objectTypeQualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token objectKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Optional<TypeDescriptorNode> typeReference() {
        return this.optionalChildInBucket(3);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(4);
    }

    public NodeList<Node> members() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(5));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "objectTypeQualifiers", "objectKeyword", "typeReference", "openBraceToken", "members", "closeBraceToken"};
    }

    public ObjectConstructorExpressionNode modify(NodeList<AnnotationNode> annotations, NodeList<Token> objectTypeQualifiers, Token objectKeyword, TypeDescriptorNode typeReference, Token openBraceToken, NodeList<Node> members, Token closeBraceToken) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), objectTypeQualifiers.underlyingListNode(), objectKeyword, typeReference, openBraceToken, members.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createObjectConstructorExpressionNode(annotations, objectTypeQualifiers, objectKeyword, typeReference, openBraceToken, members, closeBraceToken);
    }

    public ObjectConstructorExpressionNodeModifier modify() {
        return new ObjectConstructorExpressionNodeModifier(this);
    }

    public static class ObjectConstructorExpressionNodeModifier {
        private final ObjectConstructorExpressionNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private NodeList<Token> objectTypeQualifiers;
        private Token objectKeyword;
        private TypeDescriptorNode typeReference;
        private Token openBraceToken;
        private NodeList<Node> members;
        private Token closeBraceToken;

        public ObjectConstructorExpressionNodeModifier(ObjectConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.objectTypeQualifiers = oldNode.objectTypeQualifiers();
            this.objectKeyword = oldNode.objectKeyword();
            this.typeReference = oldNode.typeReference().orElse(null);
            this.openBraceToken = oldNode.openBraceToken();
            this.members = oldNode.members();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public ObjectConstructorExpressionNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withObjectTypeQualifiers(NodeList<Token> objectTypeQualifiers) {
            Objects.requireNonNull(objectTypeQualifiers, "objectTypeQualifiers must not be null");
            this.objectTypeQualifiers = objectTypeQualifiers;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withObjectKeyword(Token objectKeyword) {
            Objects.requireNonNull(objectKeyword, "objectKeyword must not be null");
            this.objectKeyword = objectKeyword;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withTypeReference(TypeDescriptorNode typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withMembers(NodeList<Node> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public ObjectConstructorExpressionNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ObjectConstructorExpressionNode apply() {
            return this.oldNode.modify(this.annotations, this.objectTypeQualifiers, this.objectKeyword, this.typeReference, this.openBraceToken, this.members, this.closeBraceToken);
        }
    }
}

