/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.QueryConstructTypeNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Objects;
import java.util.Optional;

public class QueryExpressionNode
extends ExpressionNode {
    public QueryExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<QueryConstructTypeNode> queryConstructType() {
        return this.optionalChildInBucket(0);
    }

    public QueryPipelineNode queryPipeline() {
        return (QueryPipelineNode)this.childInBucket(1);
    }

    @Deprecated
    public SelectClauseNode selectClause() {
        ClauseNode resultClause = this.resultClause();
        if (resultClause.kind() != SyntaxKind.SELECT_CLAUSE) {
            throw new IllegalStateException("select-clause not found");
        }
        return (SelectClauseNode)resultClause;
    }

    public ClauseNode resultClause() {
        return (ClauseNode)this.childInBucket(2);
    }

    public Optional<OnConflictClauseNode> onConflictClause() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"queryConstructType", "queryPipeline", "resultClause", "onConflictClause"};
    }

    public QueryExpressionNode modify(QueryConstructTypeNode queryConstructType, QueryPipelineNode queryPipeline, ClauseNode resultClause, OnConflictClauseNode onConflictClause) {
        if (this.checkForReferenceEquality(queryConstructType, queryPipeline, resultClause, onConflictClause)) {
            return this;
        }
        return NodeFactory.createQueryExpressionNode(queryConstructType, queryPipeline, resultClause, onConflictClause);
    }

    public QueryExpressionNodeModifier modify() {
        return new QueryExpressionNodeModifier(this);
    }

    public static class QueryExpressionNodeModifier {
        private final QueryExpressionNode oldNode;
        private QueryConstructTypeNode queryConstructType;
        private QueryPipelineNode queryPipeline;
        private ClauseNode resultClause;
        private OnConflictClauseNode onConflictClause;

        public QueryExpressionNodeModifier(QueryExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.queryConstructType = oldNode.queryConstructType().orElse(null);
            this.queryPipeline = oldNode.queryPipeline();
            this.resultClause = oldNode.resultClause();
            this.onConflictClause = oldNode.onConflictClause().orElse(null);
        }

        public QueryExpressionNodeModifier withQueryConstructType(QueryConstructTypeNode queryConstructType) {
            this.queryConstructType = queryConstructType;
            return this;
        }

        public QueryExpressionNodeModifier withQueryPipeline(QueryPipelineNode queryPipeline) {
            Objects.requireNonNull(queryPipeline, "queryPipeline must not be null");
            this.queryPipeline = queryPipeline;
            return this;
        }

        public QueryExpressionNodeModifier withResultClause(ClauseNode resultClause) {
            Objects.requireNonNull(resultClause, "resultClause must not be null");
            this.resultClause = resultClause;
            return this;
        }

        public QueryExpressionNodeModifier withOnConflictClause(OnConflictClauseNode onConflictClause) {
            this.onConflictClause = onConflictClause;
            return this;
        }

        public QueryExpressionNode apply() {
            return this.oldNode.modify(this.queryConstructType, this.queryPipeline, this.resultClause, this.onConflictClause);
        }
    }
}

