/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReUnicodePropertyNode;
import java.util.Objects;
import java.util.Optional;

public class ReUnicodeGeneralCategoryNode
extends ReUnicodePropertyNode {
    public ReUnicodeGeneralCategoryNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Node> categoryStart() {
        return this.optionalChildInBucket(0);
    }

    public Node reUnicodeGeneralCategoryName() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"categoryStart", "reUnicodeGeneralCategoryName"};
    }

    public ReUnicodeGeneralCategoryNode modify(Node categoryStart, Node reUnicodeGeneralCategoryName) {
        if (this.checkForReferenceEquality(categoryStart, reUnicodeGeneralCategoryName)) {
            return this;
        }
        return NodeFactory.createReUnicodeGeneralCategoryNode(categoryStart, reUnicodeGeneralCategoryName);
    }

    public ReUnicodeGeneralCategoryNodeModifier modify() {
        return new ReUnicodeGeneralCategoryNodeModifier(this);
    }

    public static class ReUnicodeGeneralCategoryNodeModifier {
        private final ReUnicodeGeneralCategoryNode oldNode;
        private Node categoryStart;
        private Node reUnicodeGeneralCategoryName;

        public ReUnicodeGeneralCategoryNodeModifier(ReUnicodeGeneralCategoryNode oldNode) {
            this.oldNode = oldNode;
            this.categoryStart = oldNode.categoryStart().orElse(null);
            this.reUnicodeGeneralCategoryName = oldNode.reUnicodeGeneralCategoryName();
        }

        public ReUnicodeGeneralCategoryNodeModifier withCategoryStart(Node categoryStart) {
            this.categoryStart = categoryStart;
            return this;
        }

        public ReUnicodeGeneralCategoryNodeModifier withReUnicodeGeneralCategoryName(Node reUnicodeGeneralCategoryName) {
            Objects.requireNonNull(reUnicodeGeneralCategoryName, "reUnicodeGeneralCategoryName must not be null");
            this.reUnicodeGeneralCategoryName = reUnicodeGeneralCategoryName;
            return this;
        }

        public ReUnicodeGeneralCategoryNode apply() {
            return this.oldNode.modify(this.categoryStart, this.reUnicodeGeneralCategoryName);
        }
    }
}

